/*
 * Decompiled with CFR 0.152.
 */
package com.arm.json;

import com.arm.json.IDecoder;
import com.arm.json.U64EncoderUtils;
import com.arm.json.U64Sequence;
import com.arm.util.ByteManipulator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class U64JsonDecoder
implements IDecoder {
    private static final String NOT_YET_IMPLEMENTED = "This is not yet implemented in the current IrisSupportLib prototype.";
    private static final String WRONG_ARGUMENTS = "Wrong Arguments";
    private static final String RESERVED = "Reserved";
    private static final String E_U64JSON_ENCODING_ERROR = "This is guaranteed to be an invalid U64JSONencoding and will always cause an E_u64json_encoding_error";

    @Override
    public List<Object> decode(U64Sequence sequence) throws IllegalArgumentException {
        List<Object> ret = null;
        if (sequence == null) {
            return null;
        }
        ret = this.decodeList(sequence.getSequence());
        return ret;
    }

    private List<Object> decodeList(List<Long> list) throws IllegalArgumentException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        long l = list.get(0);
        if (Long.compareUnsigned(l, 0L) >= 0 && Long.compareUnsigned(l, 0x1000000000000000L) < 0) {
            ret.add(l);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, 0x1000000000000000L) >= 0 && Long.compareUnsigned(l, 0x2000000000000000L) < 0) {
            ret.add(l | 0xF000000000000000L);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, 0x2000000000000000L) >= 0 && Long.compareUnsigned(l, Long.MIN_VALUE) < 0) {
            String retItem;
            long strLength = l & 0xFFL;
            int strLengthInList = (int)(strLength / 8L) + 1;
            l >>>= 8;
            if (strLength < 7L) {
                l &= 0xFFFFFFFFFFFFL;
            }
            byte[] strBytes = ByteManipulator.bytesFromLong(l);
            if (strLength <= 7L) {
                retItem = U64EncoderUtils.bytesToString(strBytes);
            } else {
                StringBuilder str = new StringBuilder();
                str.append(U64EncoderUtils.bytesToString(strBytes));
                int i = 1;
                while (i < strLengthInList) {
                    str.append(U64EncoderUtils.bytesToString(ByteManipulator.bytesFromLong(list.get(i))));
                    ++i;
                }
                retItem = str.toString();
            }
            ret.add(retItem);
            if (list.subList(strLengthInList, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(strLengthInList, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, Long.MIN_VALUE) >= 0 && Long.compareUnsigned(l, -8070450532247928832L) < 0) {
            throw new IllegalArgumentException(NOT_YET_IMPLEMENTED);
        }
        if (Long.compareUnsigned(l, -8070450532247928832L) >= 0 && Long.compareUnsigned(l, -6917529027641081856L) < 0) {
            throw new IllegalArgumentException(NOT_YET_IMPLEMENTED);
        }
        if (Long.compareUnsigned(l, -6917529027641081856L) >= 0 && Long.compareUnsigned(l, -5764607523034234880L) < 0) {
            if (list.size() < 2) {
                throw new IllegalArgumentException(WRONG_ARGUMENTS);
            }
            long containerLength = l & 0xFFFFFFFFFFFFFFFL;
            if (list.subList(2, list.size()).size() == 0) {
                return ret;
            }
            ArrayList<Object> tempArray = new ArrayList<Object>();
            tempArray.addAll(this.decodeList(list.subList(2, (int)containerLength)));
            ret.add(tempArray.toArray());
            if (list.subList((int)containerLength, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList((int)containerLength, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, -5764607523034234880L) >= 0 && Long.compareUnsigned(l, -4611686018427387904L) < 0) {
            if (list.size() < 2) {
                throw new IllegalArgumentException(WRONG_ARGUMENTS);
            }
            long numberOfMembers = list.get(1);
            if (list.subList(2, list.size()).size() == 0) {
                return ret;
            }
            ArrayList<Object> tempMap = new ArrayList<Object>();
            tempMap.addAll(this.decodeList(list.subList(2, 2 + (int)numberOfMembers * 2)));
            TreeMap map = new TreeMap();
            int i = 0;
            while ((long)i < numberOfMembers * 2L) {
                map.put((String)tempMap.get(i), tempMap.get(i + 1));
                i += 2;
            }
            ret.add(map);
            if (list.subList(2 + (int)numberOfMembers * 2, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(2 + (int)numberOfMembers * 2, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, -4611686018427387904L) >= 0 && Long.compareUnsigned(l, -4539628424389459968L) < 0) {
            l = list.get(1);
            ret.add(l);
            if (list.subList(2, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(2, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, -4539628424389459968L) >= 0 && Long.compareUnsigned(l, -4467570830351532032L) < 0) {
            l = list.get(1);
            ret.add(l);
            if (list.subList(2, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(2, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, -4467570830351532032L) >= 0 && Long.compareUnsigned(l, -3891110078048108544L) < 0) {
            if (l == -3891110078048108545L) {
                throw new IllegalArgumentException(E_U64JSON_ENCODING_ERROR);
            }
            throw new IllegalArgumentException(RESERVED);
        }
        if (Long.compareUnsigned(l, -3891110078048108544L) >= 0 && Long.compareUnsigned(l, -3819052484010180608L) < 0) {
            l = list.get(1);
            Double d = Double.longBitsToDouble(l);
            ret.add(d);
            if (list.subList(2, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(2, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, -3819052484010180608L) >= 0 && Long.compareUnsigned(l, -3746994889972252672L) < 0) {
            throw new IllegalArgumentException(RESERVED);
        }
        if (Long.compareUnsigned(l, -3746994889972252672L) >= 0 && Long.compareUnsigned(l, -3674937295934324736L) < 0) {
            long strLength = l & 0xFFFFFFFFFFFFFFL;
            int strLengthInList = (int)((strLength - 7L) / 8L) + 2;
            l = list.get(1);
            byte[] strBytes = ByteManipulator.bytesFromLong(l);
            StringBuilder str = new StringBuilder();
            str.append(U64EncoderUtils.bytesToString(strBytes));
            int i = 2;
            while (i <= strLengthInList) {
                str.append(U64EncoderUtils.bytesToString(ByteManipulator.bytesFromLong(list.get(i))));
                ++i;
            }
            String retItem = str.toString();
            ret.add(retItem);
            if (list.subList(strLengthInList, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(strLengthInList, list.size())));
            return ret;
        }
        if (l == -3674937295934324736L) {
            ret.add(null);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        if (l == -3602879701896396800L) {
            ret.add(false);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        if (l == -3530822107858468864L) {
            ret.add(true);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        if (Long.compareUnsigned(l, 0xD00000000000000L) >= 0 && Long.compareUnsigned(l, 0xE00000000000000L) < 0) {
            throw new IllegalArgumentException(RESERVED);
        }
        if (Long.compareUnsigned(l, 0xF00000000000000L) >= 0 && Long.compareUnsigned(l, -1L) <= 0) {
            ret.add(l);
            if (list.subList(1, list.size()).size() == 0) {
                return ret;
            }
            ret.addAll(this.decodeList(list.subList(1, list.size())));
            return ret;
        }
        throw new IllegalArgumentException(WRONG_ARGUMENTS);
    }
}

