/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.Files;
import com.arm.io.Messages;
import com.arm.util.ICancelable;
import com.arm.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;

public class URLDownloader {
    private static final String LOCK_FILE = ".lock";
    private File lockFile;
    private InputProvider inputProvider;
    private URLDownloadListener listener;

    public URLDownloader(File parentFolder, InputProvider inputProvider, URLDownloadListener listener) {
        this(parentFolder, null, inputProvider, listener);
    }

    public URLDownloader(File parentFolder, File lockFile, InputProvider inputProvider, URLDownloadListener listener) {
        if (parentFolder == null && lockFile == null || inputProvider == null) {
            throw new IllegalArgumentException();
        }
        if (lockFile == null) {
            lockFile = new File(parentFolder, LOCK_FILE);
        }
        this.lockFile = lockFile;
        this.inputProvider = inputProvider;
        this.listener = listener;
    }

    public File[] download() throws TimeoutException {
        return this.download(-1L, -1L);
    }

    public File[] download(long lockFileTimeout, long threadSleepTime) throws TimeoutException {
        ArrayList downloadedFiles = new ArrayList();
        Files.runWithLock(() -> {
            URL url = this.inputProvider.getNextURL();
            while (url != null) {
                File outputFile = this.inputProvider.getOutputFile(url);
                if (outputFile == null) continue;
                Tuple<String, Boolean> status = URLDownloader.downloadFile(url, outputFile);
                if (this.listener != null) {
                    this.listener.URLDownloaded(url, outputFile, (String)status.ta, (Boolean)status.tb);
                }
                if (status.ta == null) {
                    downloadedFiles.add(outputFile);
                }
                if (this.inputProvider.isCancelled()) break;
                url = this.inputProvider.getNextURL();
            }
        }, this.inputProvider, this.lockFile, lockFileTimeout, threadSleepTime);
        return downloadedFiles.toArray(new File[0]);
    }

    public static Tuple<String, Boolean> downloadFile(URL url, File outputFile) {
        boolean hasModified;
        block24: {
            boolean fileCreated = false;
            hasModified = false;
            URLConnection connection = null;
            long lastModified = outputFile.lastModified();
            if (!outputFile.exists()) {
                try {
                    Files.createFile(outputFile.getParentFile(), outputFile);
                    fileCreated = true;
                }
                catch (IOException e) {
                    return new Tuple<String, Boolean>(e.getMessage(), false);
                }
            }
            try {
                connection = url.openConnection();
                if (connection == null) {
                    Tuple<String, Boolean> tuple = new Tuple<String, Boolean>(Messages.UNABLE_TO_OPEN_URL_CONNECTION.getEnglishValue(url.toString()), false);
                    return tuple;
                }
                try {
                    connection.setIfModifiedSince(lastModified);
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
                    }
                    connection.connect();
                    if (connection.getLastModified() != 0L && connection.getLastModified() <= lastModified) break block24;
                    Throwable e = null;
                    Object var8_12 = null;
                    try (InputStream is = url.openStream();){
                        Files.copy(is, outputFile, true);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                    hasModified = true;
                }
                catch (Exception e) {
                    if (fileCreated) {
                        try {
                            Files.delete(outputFile);
                        }
                        catch (IOException iOException) {}
                    }
                    Tuple<String, Boolean> tuple = new Tuple<String, Boolean>(e.getMessage(), false);
                    return tuple;
                }
            }
            finally {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
        }
        return new Tuple<Object, Boolean>(null, hasModified);
    }

    public static interface InputProvider
    extends ICancelable {
        public URL getNextURL();

        public File getOutputFile(URL var1);
    }

    public static interface URLDownloadListener {
        public void URLDownloaded(URL var1, File var2, String var3, boolean var4);
    }
}

