/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.Files;
import com.arm.util.Platform;
import com.arm.util.ThrowableFormatter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JVMTempFolder {
    private static final String TEMP_DIR_PREFIX = "@";
    private static final String TEMP_DIR_SUFFIX = "-temp";
    private static final String LEGACY_TEMP_DIR_SUFFIX = ".libtmp";
    private static final String TEMP_DIR_SEPARATOR = "#";
    private static final String LOCK_FILE_NAME = ".lock";
    private static final Random RANDOM = new Random();
    private static final Logger log = Logger.getLogger(JVMTempFolder.class.getName());
    private static File jvmTempDir;
    private static Timer timer;
    static final long PERIOD = 60000L;
    static boolean synchronousCleanup;
    static Thread shutdownHook;

    static {
        shutdownHook = new Thread("JVM temporary folder shutdown hook"){

            @Override
            public void run() {
                try {
                    JVMTempFolder.cleanup(true);
                }
                catch (IOException ioe) {
                    log.fine("clean-up on shutdown failed:" + ThrowableFormatter.stringify(ioe));
                }
            }
        };
    }

    public static synchronized void cleanup() throws IOException {
        JVMTempFolder.cleanup(false);
    }

    private static void cleanup(boolean isShuttingDown) throws IOException {
        if (jvmTempDir != null) {
            if (!isShuttingDown) {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            JVMTempFolder.unlock(jvmTempDir);
            Files.delete(jvmTempDir);
            jvmTempDir = null;
        }
    }

    public static synchronized File getJVMTempFolder() throws IOException {
        boolean trace = log.isLoggable(Level.FINER);
        if (jvmTempDir == null) {
            if (trace) {
                log.finer("first call in this VM: create new temporary folder");
            }
            jvmTempDir = JVMTempFolder.getUniqueTempFolder(false);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            Files.mkdirs(jvmTempDir);
            JVMTempFolder.lock(jvmTempDir);
            Thread deleteLeftovers = new Thread("JVM temporary folder left-overs cleaner"){

                @Override
                public void run() {
                    JVMTempFolder.deleteLeftovers();
                }
            };
            deleteLeftovers.start();
            if (synchronousCleanup) {
                try {
                    deleteLeftovers.join();
                }
                catch (InterruptedException interruptedException) {
                    if (trace) {
                        log.finer("interrupted whilst waiting for thread \"" + deleteLeftovers.getName() + "\"... so what!?");
                    }
                }
            }
        } else if (trace) {
            log.finer("return already created temporary directory");
        }
        return jvmTempDir;
    }

    static File getUniqueTempFolder(boolean useLegacySuffix) {
        StringBuilder sb;
        File file;
        do {
            sb = new StringBuilder();
            sb.append(TEMP_DIR_PREFIX);
            sb.append(System.currentTimeMillis());
            sb.append(TEMP_DIR_SEPARATOR);
            sb.append(JVMTempFolder.getRandomInt());
            sb.append(useLegacySuffix ? LEGACY_TEMP_DIR_SUFFIX : TEMP_DIR_SUFFIX);
        } while ((file = new File(Platform.TMP, sb.toString())).exists());
        return file;
    }

    static void lock(File dir) throws IOException {
        File file = new File(dir, LOCK_FILE_NAME);
        if (!file.createNewFile()) {
            throw new IOException("could not create lock file " + file + "; file already exists");
        }
        timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)new KeepAliveTask(), 60000L, 60000L);
    }

    static void unlock(File dir) throws IOException {
        timer.cancel();
        File file = new File(dir, LOCK_FILE_NAME);
        if (file.exists() && !file.delete()) {
            throw new IOException("could not delete lock file " + file);
        }
    }

    static boolean isLocked(File dir) throws IOException {
        boolean isLocked;
        File file = new File(dir, LOCK_FILE_NAME);
        if (file.exists() && !file.isDirectory()) {
            File control = File.createTempFile("control", "lock");
            long lastModified = control.lastModified();
            boolean bl = isLocked = file.lastModified() > lastModified - 120000L;
            if (!control.delete()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("could not delete " + control + "; registering for deletion on JVM shutdown");
                }
                control.deleteOnExit();
            }
        } else {
            isLocked = false;
        }
        return isLocked;
    }

    private static int getRandomInt() {
        int result;
        while ((result = RANDOM.nextInt()) == Integer.MIN_VALUE) {
        }
        return Math.abs(result);
    }

    private static void deleteLeftovers() {
        File root = new File(Platform.TMP);
        File[] ourTempDirs = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                boolean looksLikeOurs = name.startsWith(JVMTempFolder.TEMP_DIR_PREFIX) && name.contains(JVMTempFolder.TEMP_DIR_SEPARATOR) && (name.endsWith(JVMTempFolder.TEMP_DIR_SUFFIX) || name.endsWith(JVMTempFolder.LEGACY_TEMP_DIR_SUFFIX)) && file.isDirectory();
                return looksLikeOurs;
            }
        });
        if (ourTempDirs != null) {
            boolean trace = log.isLoggable(Level.FINER);
            File[] fileArray = ourTempDirs;
            int n = ourTempDirs.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    File tempDir = fileArray[n2];
                    try {
                        if (JVMTempFolder.isLocked(tempDir)) {
                            if (trace) {
                                log.finer("skipping locked folder " + tempDir);
                            }
                        } else {
                            if (trace) {
                                log.finer("deleting old temporary folder " + tempDir);
                            }
                            Files.delete(tempDir);
                        }
                    }
                    catch (IOException ioe) {
                        if (!trace) break block8;
                        log.finer("failed to delete " + tempDir + ": " + ThrowableFormatter.stringify(ioe));
                    }
                }
                ++n2;
            }
        }
    }

    private static class KeepAliveTask
    extends TimerTask {
        private KeepAliveTask() {
        }

        @Override
        public void run() {
            File file = new File(jvmTempDir, JVMTempFolder.LOCK_FILE_NAME);
            if (!file.setLastModified(file.lastModified() + 60000L)) {
                log.fine("failed to update " + file + " last modified date");
            }
        }
    }
}

