/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class FileProperties
extends Properties {
    private final File target;
    private final boolean isXML;

    public FileProperties(File target) throws IOException {
        this(target, false, true, null);
    }

    public FileProperties(File target, boolean isXML, boolean autoLoad, Properties defaults) throws IOException {
        super(defaults);
        this.target = target;
        this.isXML = isXML;
        if (autoLoad && target.exists()) {
            this.load();
        }
    }

    public void load() throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(this.target);
            bis = new BufferedInputStream(fis);
            if (this.isXML) {
                this.loadFromXML(bis);
            } else {
                this.load(bis);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public void store() throws IOException {
        this.store(null);
    }

    public void store(String comment) throws IOException {
        this.store(comment, null);
    }

    public void store(String comment, String encoding) throws IOException {
        if (!this.target.exists()) {
            File parent = this.target.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("couldn't create " + parent);
            }
            if (!this.target.createNewFile()) {
                throw new IOException("couldn't create " + this.target);
            }
        }
        FileOutputStream fos = new FileOutputStream(this.target);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        if (this.isXML) {
            this.storeToXML(bos, comment);
        } else {
            this.store(bos, comment);
        }
        bos.close();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

