/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import java.io.File;

public class FilePath {
    public static final char EXTENSION_SEPARATOR_CHAR = '.';
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final char WINDOWS_PATH_SEPARATOR_CHAR = '\\';
    public static final String PATH_SEPARATOR = Character.toString('/');
    public static final String CURRENT_PATH = ".";

    public static final String enforceExtension(String name, String extension) {
        return FilePath.enforceExtension(name, extension, false);
    }

    public static final String enforceExtension(String name, String extension, boolean replaceExisting) {
        name = name.replace('\\', '/');
        if (extension.charAt(0) != '.') {
            extension = String.valueOf('.') + extension;
        }
        if (!name.endsWith(extension)) {
            int lastDot = name.lastIndexOf(46);
            if (name.lastIndexOf(47) > lastDot) {
                lastDot = -1;
            }
            if (lastDot != -1) {
                if (lastDot == name.length() - 1) {
                    return String.valueOf(name) + extension.substring(1);
                }
                if (replaceExisting) {
                    return String.valueOf(name.substring(0, lastDot)) + extension;
                }
            }
            return String.valueOf(name) + extension;
        }
        return name;
    }

    public static final String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(46);
        if (index == -1 || index == path.length() - 1 || index < FilePath.getLastSeparatorIndex(path)) {
            return "";
        }
        return path.substring(index);
    }

    public static final File getFile(String path) {
        return new File(FilePath.getPathForPlatform(path));
    }

    public static final File getFile(String baseFullPath, String relativePath) {
        return new File(FilePath.getPathForPlatform(FilePath.getFullPath(baseFullPath, relativePath)));
    }

    public static final String getFullPath(String baseFullPath, String relativePath) {
        String result;
        if (relativePath != null) {
            if (baseFullPath != null && baseFullPath.length() > 0) {
                baseFullPath = baseFullPath.replace('\\', '/');
                result = FilePath.isFullPath(relativePath = relativePath.replace('\\', '/')) ? relativePath : (baseFullPath.endsWith(PATH_SEPARATOR) ? String.valueOf(baseFullPath) + relativePath : String.valueOf(baseFullPath) + PATH_SEPARATOR + relativePath);
            } else {
                result = relativePath.replace('\\', '/');
            }
        } else {
            result = baseFullPath != null && baseFullPath.length() > 0 ? baseFullPath : CURRENT_PATH + PATH_SEPARATOR;
        }
        if (!FilePath.isFullPath(result)) {
            result = String.valueOf(new File(CURRENT_PATH).getAbsolutePath()) + PATH_SEPARATOR + result;
        }
        return FilePath.normalizeFullPath(result);
    }

    public static final String getFullPath(File file) {
        return file != null ? FilePath.normalizeFullPath(file.getAbsolutePath()) : null;
    }

    public static final String getLeafName(String path) {
        return FilePath.getLeafName(path, true);
    }

    public static final String getLeafName(String path, boolean includeExtension) {
        if (path != null) {
            int index = (path = path.replace('\\', '/')).lastIndexOf(47);
            if (index != -1) {
                if (index == path.length() - 1) {
                    return "";
                }
                path = path.substring(index + 1);
            }
            if (!includeExtension && (index = path.lastIndexOf(46)) != -1) {
                path = path.substring(0, index);
            }
            return path;
        }
        return null;
    }

    public static final String getParent(String path) {
        return FilePath.getParent(path, true);
    }

    public static final String getParent(String path, boolean includeTrailingSep) {
        if (path == null) {
            return null;
        }
        int index = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (index == -1) {
            return "";
        }
        return path.substring(0, index + (includeTrailingSep ? 1 : 0));
    }

    public static final int getLastSeparatorIndex(String path) {
        return Math.max(path.lastIndexOf(PATH_SEPARATOR), path.lastIndexOf(92));
    }

    public static final String getPathForPlatform(String path) {
        return path.replace('\\', '/').replace('/', File.separatorChar);
    }

    public static final boolean isDriveLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static final boolean isPathSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static final boolean isFullPath(String path) {
        int length;
        if (path != null && (length = path.length()) > 0) {
            char ch = path.charAt(0);
            return FilePath.isPathSeparator(ch) || length > 2 && path.charAt(1) == ':' && FilePath.isDriveLetter(ch) && FilePath.isPathSeparator(path.charAt(2));
        }
        return false;
    }

    public static final String normalizeFullPath(String path) {
        if (path != null) {
            char ch;
            int index;
            path = path.replace('\\', '/');
            boolean isUNCPath = (path = path.replaceAll("/\\./", PATH_SEPARATOR)).lastIndexOf("//") == 0;
            path = path.replaceAll("//", PATH_SEPARATOR);
            if (isUNCPath) {
                path = String.valueOf(PATH_SEPARATOR) + path;
            }
            do {
                if ((index = path.indexOf("/../")) == -1) continue;
                int length = 3;
                StringBuilder buffer = new StringBuilder(path);
                while (index > 0) {
                    ch = buffer.charAt(--index);
                    ++length;
                    if (ch == '/') break;
                    if (ch != ':') continue;
                    ++index;
                    --length;
                    break;
                }
                buffer.delete(index, index + length);
                path = buffer.toString();
            } while (index != -1);
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path.endsWith("/..")) {
                index = path.length() - 3;
                while (index > 0) {
                    if ((ch = path.charAt(--index)) == '/' || ch == ':') break;
                }
                path = path.substring(0, index);
            }
            if (path.length() > 1 && path.charAt(1) == ':') {
                path = String.valueOf(Character.toUpperCase(path.charAt(0))) + ":" + path.substring(2);
            }
        }
        return path;
    }
}

