/*
 * Decompiled with CFR 0.152.
 */
package com.arm.bytearray;

import com.arm.bytearray.IByteArrayConverter;
import com.arm.util.ByteManipulator;
import java.util.Arrays;

public class ByteArrayConverterBigEndian
implements IByteArrayConverter {
    private static final ByteArrayConverterBigEndian instance = new ByteArrayConverterBigEndian();

    private ByteArrayConverterBigEndian() {
    }

    public static ByteArrayConverterBigEndian getInstance() {
        return instance;
    }

    @Override
    public short convertByteArrayToShort(byte[] array) {
        return (short)((array[0] & 0xFF) << 8 | array[1] & 0xFF);
    }

    @Override
    public int convertByteArrayToInt(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    @Override
    public long convertByteArrayToLong(byte[] array) {
        return ((long)array[0] & 0xFFL) << 56 | ((long)array[1] & 0xFFL) << 48 | ((long)array[2] & 0xFFL) << 40 | ((long)array[3] & 0xFFL) << 32 | ((long)array[4] & 0xFFL) << 24 | ((long)array[5] & 0xFFL) << 16 | ((long)array[6] & 0xFFL) << 8 | (long)array[7] & 0xFFL;
    }

    @Override
    public short convertByteArrayToShort(byte[] first, int offset, byte[] second) {
        return (short)this.convertArrays(first, offset, second, 2, 8);
    }

    @Override
    public int convertByteArrayToInt(byte[] first, int offset, byte[] second) {
        return (int)this.convertArrays(first, offset, second, 4, 24);
    }

    @Override
    public long convertByteArrayToLong(byte[] first, int offset, byte[] second) {
        return this.convertArrays(first, offset, second, 8, 56);
    }

    @Override
    public byte[] convertIntToByteArray(int value) {
        byte[] data = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return data;
    }

    @Override
    public byte[] convertLongToByteArray(long value) {
        byte[] data = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return data;
    }

    @Override
    public byte[] convertShortToByteArray(short value) {
        byte[] data = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return data;
    }

    private long convertArrays(byte[] first, int offset, byte[] second, int noBytes, int shift) {
        long result = 0L;
        int remain = first.length - offset;
        int length = remain > noBytes ? noBytes : remain;
        int i = offset;
        while (i < offset + length) {
            result |= ((long)first[i] & 0xFFL) << shift;
            ++i;
            shift -= 8;
        }
        i = 0;
        while (i < noBytes - length) {
            result |= ((long)second[i] & 0xFFL) << shift;
            ++i;
            shift -= 8;
        }
        return result;
    }

    @Override
    public byte[] copyOf(byte[] original, int newLength) {
        if (newLength > original.length) {
            return ByteManipulator.shiftArrayRightWithZeroPadding(original, (newLength - original.length) * 8);
        }
        return Arrays.copyOfRange(original, original.length - newLength, original.length);
    }
}

