/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.io;

import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class IndexDataFile
extends OutputStream {
    private byte[] mBytesLastWritten;
    private ByteArrayOutputStream mByteStream;
    private DataOutputStream mData;
    private long mDataPosition;
    private LittleEndianDataOutputStream mIndex;
    private long mIndexPosition;

    public IndexDataFile(@NonNull File path) throws IOException {
        CommonFileUtils.makeDirectory((File)path);
        Throwing.closeIfThrows(tracker -> {
            this.mIndex = (LittleEndianDataOutputStream)tracker.track((Closeable)new LittleEndianDataOutputStream(new File(path, "index")));
            this.mData = new DataOutputStream(new BufferedOutputStream((OutputStream)tracker.track((Closeable)new FileOutputStream(new File(path, "data")))));
            this.mByteStream = new ByteArrayOutputStream();
            return null;
        });
    }

    public IndexDataFile(String path) throws IOException {
        this(new File(path));
    }

    @Override
    public void close() throws IOException {
        if (this.mBytesLastWritten != null && this.mByteStream.size() <= 0) {
            this.mByteStream.write(this.mBytesLastWritten);
            this.mBytesLastWritten = null;
        }
        try {
            this.writeIndex();
        }
        finally {
            try {
                this.mData.close();
                this.mData = null;
            }
            finally {
                this.mIndex.close();
                this.mIndex = null;
            }
        }
    }

    public long getIndex() {
        return this.mIndexPosition;
    }

    @Override
    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        this.mByteStream.write(buffer, offset, length);
    }

    @Override
    public void write(int value) {
        this.mByteStream.write(value);
    }

    public void writeBlobIndex(byte[] buffer, int offset, int length) throws IOException {
        if (length > 0) {
            this.mIndex.writeLELong(this.mIndexPosition);
            this.mIndex.writeLELong(this.mDataPosition);
            this.mData.write(buffer, offset, length);
            this.mDataPosition += (long)length;
            this.mBytesLastWritten = null;
        }
        ++this.mIndexPosition;
    }

    public void writeIndex() throws IOException {
        if (this.mByteStream.size() > 0) {
            byte[] buffer = this.mByteStream.toByteArray();
            this.mByteStream.reset();
            if (!Arrays.equals(buffer, this.mBytesLastWritten)) {
                this.mIndex.writeLELong(this.mIndexPosition);
                this.mIndex.writeLELong(this.mDataPosition);
                this.mData.write(buffer);
                this.mDataPosition += (long)buffer.length;
                this.mBytesLastWritten = buffer;
            }
        }
        ++this.mIndexPosition;
    }

    public void writeIndex(long index) throws IOException {
        this.mIndexPosition = index;
        this.writeIndex();
    }

    public void writeLEInt(int value) throws IOException {
        byte[] b = new byte[4];
        BufferUtils.writeLEInt((byte[])b, (int)0, (int)value);
        this.write(b);
    }
}

