/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.uids;

import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.Messages;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NonUniqueId<T extends AbstractPerVmId.PerVmNonUniquePidOrTid>
implements Comparable<NonUniqueId<?>> {
    public static final long DELTA = 1000000000L;
    private final long mEndTime;
    private final @NonNull T mId;
    private final @Nullable String mName;
    private final long mStartTime;

    public NonUniqueId(long startTime, long endTime, @NonNull T id, @Nullable String name) {
        this.mStartTime = startTime;
        this.mEndTime = endTime;
        this.mId = id;
        this.mName = name != null && !name.isEmpty() ? name : null;
    }

    @Override
    public int compareTo(NonUniqueId<?> that) {
        int idResult = ((AbstractPerVmId)this.mId).compareTo(that.mId);
        if (idResult != 0) {
            return idResult;
        }
        if (this.validAt(that.mStartTime, 0L) || that.validAt(this.mStartTime, 0L)) {
            return 0;
        }
        return (int)(this.mStartTime - that.mStartTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NonUniqueId) {
            return this.compareTo((NonUniqueId)obj) == 0;
        }
        return false;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public @NonNull T getId() {
        return this.mId;
    }

    public @Nullable String getName() {
        return this.mName;
    }

    public @NonNull String getNameOrUnresolved() {
        return (String)NullChecking.neverNullOr((Object)this.mName, (Object)Messages.NonUniqueId_UNRESOLVED);
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public int hashCode() {
        return ((AbstractPerVmId)this.mId).hashCode();
    }

    public String toString() {
        return String.valueOf(this.getId()) + ": " + this.getNameOrUnresolved() + " [" + this.getStartTime() + "-" + this.getEndTime() + "]";
    }

    public boolean validAt(long time, long extraTime) {
        return time >= this.mStartTime && time - extraTime <= this.mEndTime;
    }
}

