/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.uids;

import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.AbstractUniqueIdentifier;
import com.arm.streamline.report.model.uids.IUniqueIdMap;
import com.arm.streamline.report.model.uids.NonUniqueId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.OptionalUtils;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IUniqueIds
extends IUniqueIdMap {
    public static final int INVALID_UTID = -1;

    public static @Nullable Integer mapIntToNullableUtid(int key) {
        return key != -1 ? Integer.valueOf(key) : null;
    }

    public static int mapNullableUtidToInt(@Nullable Integer utid) {
        return utid != null ? utid : -1;
    }

    default public @NonNull Optional<NonUniqueId<?>> findNonUid(int uid) {
        return OptionalUtils.or(this.findThread(uid), () -> this.findProcess(uid)).map(abstractUniqueIdentifier -> abstractUniqueIdentifier.getNonUid());
    }

    default public @NonNull Optional<UniqueProcess> findProcess(int uid) {
        return this.getProcesses().filter(x -> x.uid == uid).findAny();
    }

    default public @NonNull Optional<UniqueThread> findThread(int uid) {
        return this.getThreads().filter(x -> x.uid == uid).findAny();
    }

    default public @NonNull Stream<AbstractUniqueIdentifier<?>> getAllUniqueIdentifiers() {
        return Stream.concat(this.getProcesses(), this.getThreads());
    }

    default public int getAnyThreadUtid() {
        UniqueThread thread = this.getAnyThread();
        return thread != null ? thread.uid : 0;
    }

    default public @Nullable UniqueThread getAnyThread() {
        Optional<@NonNull UniqueThread> thread = this.getThreads().filter(t -> t.isKernel).findFirst();
        if (thread.isPresent()) {
            return thread.get();
        }
        thread = this.getThreads().filter(t -> t.isIdle).findFirst();
        if (thread.isPresent()) {
            return thread.get();
        }
        thread = this.getThreads().findFirst();
        if (thread.isPresent()) {
            return thread.get();
        }
        return null;
    }

    @Override
    default public @NonNull Optional<AbstractPerVmId.PerVmNonUniquePidOrTid> getId(int uid) {
        return this.findNonUid(uid).map(NonUniqueId::getId);
    }

    default public @NonNull Stream<@NonNull UniqueThread> getIdleThreads() {
        return this.getThreads().filter(UniqueThread::isIdle);
    }

    default public @NonNull TIntSet getIdleUIDSet() {
        return (TIntSet)this.getIdleThreads().flatMapToInt(tuid -> IntStream.of(tuid.uid, tuid.process.uid)).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
    }

    public @NonNull Optional<UniqueProcess> getKernelProcess(long var1);

    public int getNextUniqueId();

    public @NonNull Stream<@NonNull UniqueProcess> getProcesses();

    default public @NonNull Optional<UniqueThread> getThreadAtTime(@NonNull AbstractPerVmId.PerVmNonUniqueTid id, long time) {
        return this.getThreadAtTime(id, time, 1000000000L);
    }

    default public @NonNull Optional<UniqueThread> getThreadAtTime(@NonNull AbstractPerVmId.PerVmNonUniqueTid id, long time, long extraTime) {
        return this.getThreadsById(id).filter(x -> x.getNonUid().validAt(time, extraTime)).findAny();
    }

    public @NonNull Stream<@NonNull UniqueThread> getThreads();

    default public @NonNull Stream<@NonNull UniqueThread> getThreadsById(@NonNull AbstractPerVmId.PerVmNonUniqueTid id) {
        return this.getThreads().filter(x -> ((AbstractPerVmId.PerVmNonUniqueTid)x.getNonUid().getId()).equals(id));
    }

    default public @NonNull Stream<@NonNull UniqueThread> getThreadsOf(@NonNull UniqueProcess process) {
        return this.getThreads().filter(x -> x.process.equals(process));
    }

    @Override
    default public @NonNull Optional<IntStream> getThreadUidsOf(int upid) {
        return this.findProcess(upid).map(this::getThreadsOf).map(x -> x.mapToInt(AbstractUniqueIdentifier::getUid));
    }

    default public boolean isEmpty() {
        return !this.getThreads().findAny().isPresent();
    }
}

