/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.timeline;

import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import com.arm.streamline.report.model.icounters.io.timeline.AbstractLadderDataSource;
import com.arm.streamline.report.model.icounters.io.timeline.IndexRecompute;
import com.arm.utils.collections.Pair;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class IncidentCounterDataSource
extends AbstractLadderDataSource<Pair<IndexRecompute, IndexRecompute>>
implements IIncidentCounterDataSource {
    public static @NonNull IIncidentCounterDataSource create(@NonNull File dataPointIndex) throws IOException {
        @NonNull File timelineDir = new File(dataPointIndex, "timeline");
        @NonNull File callpaths = new File(timelineDir, "callpaths");
        @NonNull File instructions = new File(timelineDir, "instructions");
        return new IncidentCounterDataSource(callpaths, instructions);
    }

    private static @Nullable Pair<@NonNull IndexRecompute, @NonNull IndexRecompute> getDataFile(@NonNull File callPathsDirectory, @NonNull File instructionsDirectory, int scale) throws IOException {
        @NonNull File callPathsDataFile = new File(callPathsDirectory, String.format("data_%d_us.bin", scale));
        @NonNull File instructionsDataFile = new File(instructionsDirectory, String.format("data_%d_us.bin", scale));
        if (!callPathsDataFile.isDirectory() || !instructionsDataFile.isDirectory()) {
            return null;
        }
        return new Pair((Object)new IndexRecompute(callPathsDataFile, IncidentCounterDataSource::loadData, 1024), (Object)new IndexRecompute(instructionsDataFile, IncidentCounterDataSource::loadData, 1024));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable TIntLongMap loadData(byte[] data, boolean compressed) throws IOException {
        TIntLongHashMap result = new TIntLongHashMap(10, 0.5f, -1, -1L);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (LittleEndianDataInputStream in = new LittleEndianDataInputStream(data, compressed);){
                while (true) {
                    int key;
                    if ((key = in.readLEInt() & 0xFFFFFF) == 0xFFFFFF) {
                        if ($assertionsDisabled) return null;
                        if (result.isEmpty()) return null;
                        throw new AssertionError();
                    }
                    long value = in.readLELong();
                    result.adjustOrPutValue(key, value, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return result;
        }
    }

    private IncidentCounterDataSource(@NonNull File callPathsDirectory, @NonNull File instructionsDirectory) throws IOException {
        super(scale -> IncidentCounterDataSource.getDataFile(callPathsDirectory, instructionsDirectory, scale));
    }

    @Override
    public final void loadRange(boolean wantInstructions, long startTick, long endTick, @NonNull BiConsumer<@Nullable TIntLongMap, @Nullable TIntLongMap> consumer) throws InterruptedException {
        this.walkLadder(startTick, endTick, (ladderIndex, blockIndex) -> {
            try {
                @NonNull Pair<@Nullable TIntLongMap, @Nullable TIntLongMap> dataBlockPair = this.getDataBlockPair(wantInstructions, ladderIndex, blockIndex);
                consumer.accept((TIntLongMap)dataBlockPair.first, (TIntLongMap)dataBlockPair.second);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Pair<@Nullable TIntLongMap, @Nullable TIntLongMap> getDataBlockPair(boolean wantInstructions, int ladderIndex, long blockIndex) throws IOException {
        @NonNull @NonNull @NonNull Pair dataFilePair = (Pair)this.getDataFileByLadderIndex(ladderIndex);
        @Nullable TIntLongMap callPathsData = (TIntLongMap)((IndexRecompute)dataFilePair.first).getDataBlock(blockIndex);
        TIntLongMap instructionsData = wantInstructions ? (TIntLongMap)((IndexRecompute)dataFilePair.second).getDataBlock(blockIndex) : null;
        return new Pair((Object)callPathsData, (Object)instructionsData);
    }
}

