/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.structure;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.report.model.icounters.io.IFunctionsWriter;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class FunctionsWriter
implements IFunctionsWriter {
    private final @NonNull XMLGenerator xml;

    public FunctionsWriter(@NonNull String reportDirectory) throws IOException {
        this.xml = XMLGenerator.create((File)new File(reportDirectory, "icounter/functions.xml"));
        try {
            this.xml.startDocument();
            this.xml.startTag("functions");
        }
        catch (Throwable t) {
            try {
                this.xml.close();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.xml.endTag();
            this.xml.endDocument();
        }
        finally {
            this.xml.close();
        }
    }

    @Override
    public void write(int id, @NonNull String name, int size, int stack, int fileId, boolean script, int firstInstruction, int lastInstruction, int firstSourceline, int lastSourceline, boolean unknown) throws IOException {
        this.xml.startEmptyTag("function");
        this.xml.addAttribute("id", id);
        this.xml.addAttribute("name", name);
        this.xml.addAttributeNot("size", size, 0);
        this.xml.addAttributeNot("stack", stack, 0);
        this.xml.addAttributeNot("file", fileId, 0);
        this.xml.addAttributeNot("line", firstSourceline, 0);
        this.xml.addAttributeBool("script", script);
        this.xml.addAttributeBool("unknown", unknown);
        if (firstInstruction != 0 || lastInstruction != 0) {
            this.xml.addAttribute("first_instruction", firstInstruction);
            this.xml.addAttribute("last_instruction", lastInstruction);
        }
        if (firstSourceline != 0 || lastSourceline != 0) {
            this.xml.addAttribute("first_sourceline", firstSourceline);
            this.xml.addAttribute("last_sourceline", lastSourceline);
        }
    }
}

