/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.structure;

import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.utility.text.JavaMethodNameDemangler;
import com.arm.streamline.report.model.FunctionImpl;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.io.IFunctionsReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FunctionsReader
implements IFunctionsReader {
    public static final String ATTR_COLUMN = "column";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_FIRST_INSTRUCTION = "first_instruction";
    public static final String ATTR_FIRST_SOURCELINE = "first_sourceline";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LAST_INSTRUCTION = "last_instruction";
    public static final String ATTR_LAST_SOURCELINE = "last_sourceline";
    public static final String ATTR_LINE = "line";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SCRIPT = "script";
    public static final String ATTR_SECTION = "section";
    public static final String ATTR_SHORT_NAME = "short_name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_STACK = "stack";
    public static final String ATTR_UNKNOWN = "unknown";
    public static final String ATTR_UNMANGLED_NAME = "unmangled_name";
    public static final String STATIC_FILENAME = "icounter/functions.xml";
    public static final String TAG_FUNCTION = "function";
    public static final String TAG_FUNCTIONS = "functions";
    private static final String INVALID_COLUMN = "Corrupt Functions file: Function {0}: Invalid column ({1}).";
    private static final String INVALID_FILE = "Corrupt Functions file: Function {0}: Invalid file ({1}).";
    private static final String INVALID_FUNCTION_ID = "Corrupt Functions file: Function {0}: Invalid ID ({1}).";
    private static final String INVALID_FUNCTION_NAME = "Corrupt Functions file: Function {0}: Name cannot be empty.";
    private static final String INVALID_JAVA_FUNCTION_NAME = "Corrupt Functions file: Invalid name for Java function found: ({0}).";
    private static final String INVALID_LINE = "Corrupt Functions file: Function {0}: Invalid line ({1}).";
    private static final String INVALID_SIZE = "Corrupt Functions file: Function {0}: Invalid size ({1}).";
    private final @NonNull IInstructionsFile instructionsFile;
    private final @NonNull File reportDirectory;
    private final @NonNull List<@NonNull SourceFile> sourceFiles;
    private final @NonNull IProgressTracker tracker;

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    private static void loadFunctions(@NonNull XMLParser in, @NonNull IProgressTracker tracker, @NonNull List<@NonNull SourceFile> sourceFiles, @NonNull IInstructionsFile instructionsFile, @NonNull Consumer<@NonNull IFunction> consumer) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        int count = 0;
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_FUNCTION.equals(tag)) {
                IFunction function = FunctionsReader.newFunction(in, count++, sourceFiles, instructionsFile);
                consumer.accept(function);
                continue;
            }
            in.skip();
        }
        tracker.update();
    }

    private static @Nullable String makeUnmangledName(@NonNull String name, @Nullable String unmangledName) throws IOException {
        if (unmangledName == null && JavaMethodNameDemangler.matchesMangledJavaSignature((String)name)) {
            try {
                return JavaMethodNameDemangler.parseMethodSignature((String)name);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(MessageFormat.format(INVALID_JAVA_FUNCTION_NAME, name));
            }
        }
        return unmangledName;
    }

    private static @NonNull IFunction newFunction(@NonNull XMLParser in, int index, @NonNull List<@NonNull SourceFile> sourceFiles, @NonNull IInstructionsFile instructionsFile) throws IOException {
        int section = in.getIntegerAttribute(ATTR_SECTION, 0);
        int fileIndex = in.getIntegerAttribute(ATTR_FILE, 0);
        int mID = in.getIntegerAttribute(ATTR_ID, -1);
        if (mID != index) {
            throw new IOException(MessageFormat.format(INVALID_FUNCTION_ID, index, mID));
        }
        boolean mScript = in.isAttributeSet(ATTR_SCRIPT);
        @NonNull String mName = FunctionsReader.validateName(mID, in.getAttribute(ATTR_NAME));
        @Nullable String mUnmangledName = FunctionsReader.makeUnmangledName(mName, in.getAttribute(ATTR_UNMANGLED_NAME));
        @Nullable String mShortName = in.getAttribute(ATTR_SHORT_NAME);
        boolean mUnknown = in.isAttributeSet(ATTR_UNKNOWN);
        int mSize = in.getIntegerAttribute(ATTR_SIZE, 2);
        if (mSize < 0) {
            throw new IOException(MessageFormat.format(INVALID_SIZE, mID, mSize));
        }
        int mStack = in.getIntegerAttribute(ATTR_STACK, -1);
        int mFirstInstructionIndex = in.getIntegerAttribute(ATTR_FIRST_INSTRUCTION, 0);
        int mLastInstructionIndex = in.getIntegerAttribute(ATTR_LAST_INSTRUCTION, 0);
        int mFirstSourceLine = in.getIntegerAttribute(ATTR_FIRST_SOURCELINE, 0);
        int mLastSourceLine = in.getIntegerAttribute(ATTR_LAST_SOURCELINE, 0);
        int mLine = in.getIntegerAttribute(ATTR_LINE, 0);
        if (mLine < 0) {
            throw new IOException(MessageFormat.format(INVALID_LINE, mID, mLine));
        }
        int mColumn = in.getIntegerAttribute(ATTR_COLUMN, 0);
        if (mColumn < 0) {
            throw new IOException(MessageFormat.format(INVALID_COLUMN, mID, mColumn));
        }
        if (fileIndex < 0 || fileIndex >= sourceFiles.size()) {
            throw new IOException(MessageFormat.format(INVALID_FILE, mID, fileIndex));
        }
        in.skip();
        @NonNull SourceFile mFile = sourceFiles.get(fileIndex);
        long mSection = (long)section | (long)mFile.getImageIndex() << 32;
        @NonNull SourceFile imageFile = sourceFiles.get(mFile.getImageIndex());
        long address = instructionsFile.getAddressForIndex(mFirstInstructionIndex);
        return new FunctionImpl(instructionsFile, mID, mScript, mUnknown, mName, mShortName, mUnmangledName, mSize, mFirstInstructionIndex, mLastInstructionIndex, mFirstSourceLine, mLastSourceLine, mLine, mColumn, mStack, mFile, mSection, imageFile, address);
    }

    private static @NonNull String validateName(int id, @Nullable String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException(MessageFormat.format(INVALID_FUNCTION_NAME, id));
        }
        return name;
    }

    public FunctionsReader(@NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull List<@NonNull SourceFile> sourceFiles, @NonNull IInstructionsFile instructionsFile) throws IOException, InterruptedException {
        this.tracker = tracker;
        this.sourceFiles = sourceFiles;
        this.instructionsFile = instructionsFile;
        this.reportDirectory = reportDirectory;
    }

    @Override
    public void read(@NonNull Consumer<@NonNull IFunction> consumer) throws IOException, InterruptedException {
        this.tracker.setSubTaskTitle(Messages.FUNCTIONS);
        Throwable throwable = null;
        Object var3_4 = null;
        try (CountedInputStream cin = new CountedInputStream(FunctionsReader.getFile(this.reportDirectory));){
            this.tracker.setProgressProvider((IProgressProvider)cin);
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (XMLParser in = XMLParser.create((InputStream)cin);){
                String tag;
                while ((tag = in.nextTag()) != null) {
                    if (TAG_FUNCTIONS.equals(tag)) {
                        FunctionsReader.loadFunctions(in, this.tracker, this.sourceFiles, this.instructionsFile, consumer);
                        continue;
                    }
                    in.skip();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.tracker.update();
            this.tracker.setProgressProvider(null);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

