/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.structure;

import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IVirtualMachineBasicProperties;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPathCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.IInstructionCounterCallPathCounterSetFactory;
import com.arm.streamline.report.model.icounters.io.ICallPathFactory;
import com.arm.streamline.report.model.icounters.io.ICallPathsReader;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CallPathsReader<T extends ICallPath, U extends IInstructionCounterCallPathCounterSetFactory>
implements ICallPathsReader<T, U> {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SHOW_PROCESSES = "show_processes";
    public static final int MAGIC_FUNCTION_ID_PID_TID_UID = -1;
    public static final int MAGIC_PARENT_ID_NO_PARENT = -1;
    public static final String STATIC_FILENAME = "icounter/callpaths.xml";
    public static final String TAG_LINK = "link";
    public static final String TAG_PROFILE = "profile";
    private static final @NonNull IInstructionCounterCallPathCounterSetFactory GLOBAL_COUNTER_VIEW_FACTORY = new IInstructionCounterCallPathCounterSetFactory(){
        final @NonNull IInstructionCounterCallPathCounterSet counterSet = new IInstructionCounterCallPathCounterSet(){

            @Override
            public long getSelfCounterValue(int eventId, int dataPointIndex) {
                return 0L;
            }

            @Override
            public long getTotalCounterValue(int eventId, int dataPointIndex) {
                return 0L;
            }
        };

        @Override
        public @NonNull IInstructionCounterCallPathCounterSet create(@NonNull ICallPath callPath) {
            return this.counterSet;
        }

        @Override
        public @NonNull IInstructionCounterFunctionView getFunctionViewById(int id) {
            throw new AssertionError();
        }
    };
    private static final @NonNull String GLOBAL_FILENAME = "icounter/callpaths.bin";
    private static final @NonNull String INVALID_CALL_PATH_ID = "Corrupt callpath file: Invalid ID ({0}).";
    private static final @NonNull String INVALID_CALL_PATH_ID_AT_OFFSET = "Corrupt callpath file: Invalid call path ID at offset {0}";
    private static final @NonNull String INVALID_FUNCTION_ID_AT_OFFSET = "Corrupt callpath file: Invalid function ID at offset {0}";
    private static final @NonNull String SOURCE_FILENAME_FORMAT = "icounter/%s/callpaths.bin";
    private final @NonNull ICallPathFactory<T> callPathFactory;
    private final @NonNull TIntObjectMap<String> callPathNames;
    private final @NonNull Function<int @NonNull [], @NonNull U> counterViewFactory;
    private int iterationCounter;
    private final @NonNull File reportDir;
    private final @Nullable Integer sourceId;
    private final @NonNull IProgressTracker tracker;
    private final @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap;

    public static <T extends ICallPath> @NonNull CallPathsReader<T, ?> globalReader(@NonNull IProgressTracker tracker, @NonNull File reportDir, @NonNull ICallPathFactory<T> callPathFactory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull TIntObjectMap<String> callPathNames) {
        return new CallPathsReader<T, IInstructionCounterCallPathCounterSetFactory>(tracker, reportDir, callPathFactory, vmStateMap, callPathNames, ids -> GLOBAL_COUNTER_VIEW_FACTORY);
    }

    public static boolean loadCallPathNames(@NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull TIntObjectMap<String> callPathNames) throws IOException, InterruptedException {
        File staticFile = CallPathsReader.getStaticFile(reportDirectory);
        boolean showProcesses = true;
        tracker.setSubTaskTitle(Messages.PROFILE);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (CountedInputStream countStaticIn = new CountedInputStream(staticFile);){
                tracker.setProgressProvider((IProgressProvider)countStaticIn);
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (XMLParser in = XMLParser.create((InputStream)countStaticIn);){
                    String tag;
                    while ((tag = in.nextTag()) != null) {
                        if (TAG_PROFILE.equals(tag)) {
                            showProcesses = in.isAttributeSet(ATTR_SHOW_PROCESSES, true);
                            String marker = in.getMarker();
                            while ((tag = in.nextTag(marker)) != null) {
                                if (TAG_LINK.equals(tag)) {
                                    int id = in.getIntegerAttribute(ATTR_ID, -1);
                                    String name = in.getAttribute(ATTR_NAME, "");
                                    callPathNames.put(id, (Object)name);
                                }
                                in.skip();
                                tracker.update();
                            }
                        } else {
                            in.skip();
                        }
                        tracker.update();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            tracker.update();
            tracker.setProgressProvider(null);
        }
        return showProcesses;
    }

    private static <T extends ICallPath> void addRecord(@NonNull TIntObjectMap<Record<T>> result, @NonNull Record<T> record) throws IOException {
        Record previousRecord = (Record)result.put(record.id, record);
        if (previousRecord != null) {
            throw new IOException(MessageFormat.format(INVALID_CALL_PATH_ID_AT_OFFSET, record.fileOffset));
        }
    }

    private static @NonNull File getStaticFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    private static @Nullable File getStructureBinFile(@NonNull File reportDir, @Nullable Integer sourceId) {
        if (sourceId != null) {
            return CallPathsReader.ifIsFile(new File(reportDir, String.format(SOURCE_FILENAME_FORMAT, sourceId)));
        }
        return CallPathsReader.ifIsFile(new File(reportDir, GLOBAL_FILENAME));
    }

    private static @Nullable File ifIsFile(@NonNull File file) {
        return file.isFile() ? file : null;
    }

    private static <T extends ICallPath> @NonNull Record<T> readCurrentFormatRecord(@NonNull LittleEndianDataInputStream in, long fileOffset) throws IOException {
        int typeProtocolValue = in.readLEInt();
        int id = in.readLEInt();
        int parentID = in.readLEInt();
        long value = in.readLELong();
        Integer parent = parentID != -1 ? Integer.valueOf(parentID) : null;
        @Nullable CallPathNodeType type = CallPathNodeType.find(typeProtocolValue);
        if (id == -1) {
            throw new IOException(MessageFormat.format(INVALID_CALL_PATH_ID_AT_OFFSET, fileOffset));
        }
        if (type == null) {
            throw new IOException(MessageFormat.format(INVALID_CALL_PATH_ID_AT_OFFSET, fileOffset));
        }
        return new Record(fileOffset, type, id, parent, value);
    }

    private static <T extends ICallPath> @NonNull TIntObjectMap<Record<T>> readCurrentFormatRecords(@NonNull File file, @NonNull IProgressTracker tracker) throws IOException {
        TIntObjectHashMap result = new TIntObjectHashMap();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                CountedInputStream cin = new CountedInputStream(file);
                try {
                    tracker.setProgressProvider((IProgressProvider)cin);
                    long fileOffset = 0L;
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try {
                        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)cin);
                        try {
                            while (true) {
                                @NonNull Record<T> record = CallPathsReader.readCurrentFormatRecord(in, fileOffset);
                                fileOffset += 20L;
                                CallPathsReader.addRecord(result, record);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (cin != null) {
                        cin.close();
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return result;
        }
    }

    private static <T extends ICallPath> @NonNull TIntObjectMap<Record<T>> readRecords(@NonNull File reportDir, @NonNull IProgressTracker tracker, @Nullable Integer sourceId) throws IOException {
        tracker.setSubTaskTitle(Messages.CALL_PATHS);
        @Nullable File currentFile = CallPathsReader.getStructureBinFile(reportDir, sourceId);
        if (currentFile != null) {
            return CallPathsReader.readCurrentFormatRecords(currentFile, tracker);
        }
        return new TIntObjectHashMap(0);
    }

    public CallPathsReader(@NonNull IProgressTracker tracker, @NonNull File reportDir, int sourceId, @NonNull ICallPathFactory<T> callPathFactory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull TIntObjectMap<String> callPathNames, @NonNull Function<int @NonNull [], @NonNull U> counterViewFactory) {
        this.tracker = tracker;
        this.reportDir = reportDir;
        this.sourceId = sourceId;
        this.callPathFactory = callPathFactory;
        this.counterViewFactory = counterViewFactory;
        this.vmStateMap = vmStateMap;
        this.callPathNames = callPathNames;
    }

    private CallPathsReader(@NonNull IProgressTracker tracker, @NonNull File reportDir, @NonNull ICallPathFactory<T> callPathFactory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull TIntObjectMap<String> callPathNames, @NonNull Function<int @NonNull [], @NonNull U> counterViewFactory) {
        this.tracker = tracker;
        this.reportDir = reportDir;
        this.sourceId = null;
        this.callPathFactory = callPathFactory;
        this.counterViewFactory = counterViewFactory;
        this.vmStateMap = vmStateMap;
        this.callPathNames = callPathNames;
    }

    @Override
    public @NonNull U read(@NonNull Consumer<@NonNull T> consumer) throws IOException, InterruptedException {
        @NonNull TIntObjectMap<Record<T>> records = CallPathsReader.readRecords(this.reportDir, this.tracker, this.sourceId);
        int @NonNull [] ids = records.keys();
        Arrays.sort(ids);
        @NonNull IInstructionCounterCallPathCounterSetFactory counterViews = (IInstructionCounterCallPathCounterSetFactory)this.counterViewFactory.apply(ids);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.loadRecord(records, id, counterViews, consumer);
            ++n2;
        }
        this.tracker.update();
        this.tracker.setProgressProvider(null);
        return (U)counterViews;
    }

    private @Nullable T loadRecord(@NonNull TIntObjectMap<Record<T>> records, int id, @NonNull IInstructionCounterCallPathCounterSetFactory countersFactory, @NonNull Consumer<@NonNull T> consumer) throws IOException, InterruptedException {
        @Nullable Record record = (Record)records.get(id);
        if (record == null) {
            throw new IOException(MessageFormat.format(INVALID_CALL_PATH_ID, id));
        }
        @Nullable T existingItem = record.callPath;
        if (existingItem != null) {
            return existingItem;
        }
        @Nullable Integer parentId = record.parentId;
        Object parent = parentId != null ? (Object)this.loadRecord(records, parentId, countersFactory, consumer) : null;
        @NonNull T result = switch (record.type) {
            case CallPathNodeType.FUNCTION -> {
                @Nullable IInstructionCounterFunctionView function = countersFactory.getFunctionViewById((int)record.value);
                if (function == null) {
                    throw new IOException(MessageFormat.format(INVALID_FUNCTION_ID_AT_OFFSET, record.fileOffset));
                }
                yield this.callPathFactory.createForFunction(id, parent, function, countersFactory);
            }
            case CallPathNodeType.UID -> {
                @Nullable String name = (String)this.callPathNames.get(id);
                yield this.callPathFactory.createForUID(id, parent, (int)record.value, name, countersFactory);
            }
            case CallPathNodeType.VMUID -> {
                @Nullable IVirtualMachineBasicProperties perVmState = (IVirtualMachineBasicProperties)this.vmStateMap.get(record.value);
                String name = perVmState != null ? perVmState.getVmName() : null;
                yield this.callPathFactory.createForVmUID(id, parent, record.value, name, countersFactory);
            }
            default -> throw new AssertionError((Object)record.type);
        };
        record.callPath = result;
        consumer.accept(result);
        if (++this.iterationCounter % 50000 == 0) {
            this.tracker.update();
        }
        return result;
    }

    private static final class Record<T extends ICallPath> {
        public @Nullable T callPath;
        public final long fileOffset;
        public final int id;
        public final @Nullable Integer parentId;
        public final @NonNull CallPathNodeType type;
        public final long value;

        public Record(long fileOffset, @NonNull CallPathNodeType type, int id, @Nullable Integer parentId, long value) {
            this.fileOffset = fileOffset;
            this.type = type;
            this.id = id;
            this.parentId = parentId;
            this.value = value;
        }
    }
}

