/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.metrics;

import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.instructionandsource.InstructionsAndSourcefileLineIncidentCounterAccumulator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public abstract class InstructionsMetricsLoader {
    public static void load(@NonNull IProgressTracker tracker, @NonNull File dataPointDir, int eventId, int dataPointIndex, @NonNull IInstructionsAndSourcefileLineCounterViews instructionsViews) throws IOException, InterruptedException {
        int count = instructionsViews.numberOfInstructions();
        Throwable throwable = null;
        Object var7_8 = null;
        try (InstructionsAndSourcefileLineIncidentCounterAccumulator accumulator = instructionsViews.createAccumulator(eventId, dataPointIndex);){
            @NonNull File file = new File(new File(dataPointDir, "metrics"), "instructions.bin");
            tracker.setSubTaskTitle(file.getPath());
            try {
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (CountedInputStream countDynamicIn = new CountedInputStream(file);){
                    tracker.setProgressProvider((IProgressProvider)countDynamicIn);
                    Throwable throwable3 = null;
                    Object var14_20 = null;
                    try (LittleEndianDataInputStream dynamicIn = new LittleEndianDataInputStream((InputStream)countDynamicIn);){
                        int i = 0;
                        while (i < count) {
                            long value = dynamicIn.readLELong();
                            accumulator.addSelection(i, value);
                            if (i % 50000 == 0) {
                                tracker.update();
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            tracker.setProgressProvider(null);
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }
}

