/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.instructionandsource;

import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SourcefileLineMap
implements ISourcefileLineMap {
    private static final int DYNAMIC_DATA_SIZE = 8;
    private static final String DYNAMIC_FILENAME = "icounter/lines.bin";
    private final int @NonNull [] functionIdMap;
    private final @NonNull IntFunction<@NonNull IFunction> functionLookup;
    private final @NonNull BitSet isInlined;
    private final int @NonNull [] lineMap;

    public static @NonNull ISourcefileLineMap load(@NonNull File reportDir, @NonNull IntFunction<@NonNull IFunction> functionLookup, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        @NonNull File dynamicFile = SourcefileLineMap.getFile(reportDir);
        int count = (int)(dynamicFile.length() / 8L);
        int @NonNull [] lineMap = new int[count];
        @NonNull BitSet isInlined = new BitSet(count);
        int @NonNull [] functionIdMap = new int[count];
        tracker.setSubTaskTitle(Messages.LINES);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (CountedInputStream cin = new CountedInputStream(dynamicFile);){
                tracker.setProgressProvider((IProgressProvider)cin);
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)cin);){
                    int i = 0;
                    while (i < count) {
                        int line = in.readLEInt();
                        int functionAndInline = in.readLEInt();
                        boolean inlined = (functionAndInline & 0x1000000) != 0;
                        int function = functionAndInline & 0xFFFFFF;
                        lineMap[i] = line;
                        isInlined.set(i, inlined);
                        functionIdMap[i] = function;
                        if (i % 50000 == 0) {
                            tracker.update();
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        tracker.setProgressProvider(null);
        return new SourcefileLineMap(functionLookup, lineMap, isInlined, functionIdMap);
    }

    private static @NonNull File getFile(File reportDir) {
        return new File(reportDir, DYNAMIC_FILENAME);
    }

    public SourcefileLineMap(@NonNull IntFunction<@NonNull IFunction> functionLookup, int @NonNull [] lineMap, @NonNull BitSet isInlined, int @NonNull [] functionIdMap) {
        this.functionLookup = functionLookup;
        this.lineMap = lineMap;
        this.isInlined = isInlined;
        this.functionIdMap = functionIdMap;
    }

    @Override
    public void forEachIndexGetFunctionIndex(@NonNull ISourcefileLineMap.IFunctionIndexConsumer consumer) {
        int index = 0;
        while (index < this.functionIdMap.length) {
            consumer.accept(index, this.functionIdMap[index]);
            ++index;
        }
    }

    @Override
    public @Nullable IFunction getFunction(int position) {
        if (position < 0) {
            return null;
        }
        return this.functionLookup.apply(this.functionIdMap[position]);
    }

    @Override
    public final @Nullable IFunction getFunction(@NonNull SourceFile file, int line) {
        int position = this.indexOf(file, line);
        return this.getFunction(position);
    }

    @Override
    public final int indexOf(@NonNull SourceFile file, int line) {
        if (this.size() > 0) {
            int low = file.getIndexOffset();
            int high = low + file.getIndexCount() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int value = this.lineMap[mid];
                if (value < line) {
                    low = mid + 1;
                    continue;
                }
                if (value > line) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
        }
        return -1;
    }

    @Override
    public final boolean isInlined(@NonNull SourceFile file, int line) {
        int position = this.indexOf(file, line);
        if (position < 0) {
            return false;
        }
        return this.isInlined.get(position);
    }

    @Override
    public final int size() {
        return this.lineMap.length;
    }
}

