/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.instructionandsource;

import com.arm.streamline.report.model.icounters.impl.IIncidentCounterAccumulatorResultConsumer;
import com.arm.streamline.report.model.icounters.instructionandsource.InMemoryInstructionsAndSourcefileLineIncidentCounterValues;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionsAndSourcefileLineIncidentCounterAccumulator
implements Closeable {
    private final int dataPointIndex;
    private final int eventId;
    private final long @NonNull [] functionCumulativeSourceFileLineCount;
    private final @NonNull IntUnaryOperator indexToSourceFileLineIndexMapper;
    private final long @NonNull [] instructionCount;
    private final @NonNull IIncidentCounterAccumulatorResultConsumer<InMemoryInstructionsAndSourcefileLineIncidentCounterValues> resultConsumer;
    private final long @NonNull [] sourceFileLineCount;
    private final @NonNull IntUnaryOperator sourceFileLineIndexToFunctionIndexMapper;

    public InstructionsAndSourcefileLineIncidentCounterAccumulator(int eventId, int dataPointIndex, int instructions, int sourceFileLines, int functions, @NonNull IntUnaryOperator indexToSourceFileLineIndexMapper, @NonNull IntUnaryOperator sourceFileLineIndexToFunctionIndexMapper, @NonNull IIncidentCounterAccumulatorResultConsumer<InMemoryInstructionsAndSourcefileLineIncidentCounterValues> resultConsumer) {
        this.eventId = eventId;
        this.dataPointIndex = dataPointIndex;
        this.indexToSourceFileLineIndexMapper = indexToSourceFileLineIndexMapper;
        this.sourceFileLineIndexToFunctionIndexMapper = sourceFileLineIndexToFunctionIndexMapper;
        this.resultConsumer = resultConsumer;
        this.instructionCount = new long[instructions];
        this.sourceFileLineCount = new long[sourceFileLines];
        this.functionCumulativeSourceFileLineCount = new long[functions];
    }

    public void addSelection(int instructionIndex, long value) {
        if (instructionIndex == 0 && this.instructionCount.length == 0) {
            return;
        }
        int sourceFileLineIndex = this.indexToSourceFileLineIndexMapper.applyAsInt(instructionIndex);
        int n = instructionIndex;
        this.instructionCount[n] = this.instructionCount[n] + value;
        if (sourceFileLineIndex >= 0) {
            int n2 = sourceFileLineIndex;
            this.sourceFileLineCount[n2] = this.sourceFileLineCount[n2] + value;
            int functionIndex = this.sourceFileLineIndexToFunctionIndexMapper.applyAsInt(sourceFileLineIndex);
            if (functionIndex >= 0) {
                int n3 = functionIndex;
                this.functionCumulativeSourceFileLineCount[n3] = this.functionCumulativeSourceFileLineCount[n3] + value;
            }
        }
    }

    public void addSelection(@Nullable TIntLongMap samples) {
        if (samples != null) {
            TIntLongIterator iterator = samples.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                int id = iterator.key();
                long value = iterator.value();
                this.addSelection(id, value);
            }
        }
    }

    @Override
    public void close() throws IOException {
        InMemoryInstructionsAndSourcefileLineIncidentCounterValues result = new InMemoryInstructionsAndSourcefileLineIncidentCounterValues(this.instructionCount, this.sourceFileLineCount, this.functionCumulativeSourceFileLineCount);
        this.resultConsumer.accept(this.eventId, this.dataPointIndex, result);
    }
}

