/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.instructionandsource;

import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.IRawInstructionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterInstructionCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourceLineCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourceLineFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineIncidentCounterValues;
import com.arm.streamline.report.model.icounters.instructionandsource.InMemoryInstructionsAndSourcefileLineIncidentCounterValues;
import com.arm.streamline.report.model.icounters.instructionandsource.InstructionsAndSourcefileLineIncidentCounterAccumulator;
import com.arm.streamline.report.model.icounters.instructionandsource.OnDiskInstructionsAndSourcefileLineIncidentCounterValues;
import com.arm.utils.ArrayUtils;
import com.arm.utils.function.IThrowingFunction;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionsAndSourcefileLineCounterViews
implements IInstructionsAndSourcefileLineCounterViews,
Closeable {
    private final int @NonNull [] instructionIndexToSourceFileLineMapIndex;
    private final @NonNull IInstructionsFile instructionsFile;
    private final int minFunctionId;
    private final int numFunctionIds;
    private final @NonNull ISourcefileLineMap sourcefileLineMap;
    private final int @NonNull [] sourceFileLineMapIndexToFunctionIndex;
    private final @NonNull IValueMapper valueMapper;
    private final @Nullable IInstructionsAndSourcefileLineIncidentCounterValues @NonNull [] @NonNull [] valuesByDataPointIndex;

    public InstructionsAndSourcefileLineCounterViews(@NonNull IRawInstructionsFile instructionsFile, @NonNull ISourcefileLineMap sourcefileLineMap, int @NonNull [] numberOfDataPointIndexesByEventId, @NonNull IValueMapper valueMapper) {
        assert (numberOfDataPointIndexesByEventId.length >= 0);
        this.instructionsFile = instructionsFile;
        this.sourcefileLineMap = sourcefileLineMap;
        this.valueMapper = valueMapper;
        @Nullable IInstructionsAndSourcefileLineIncidentCounterValues @NonNull [] @NonNull [] valuesByDataPointIndex = (IInstructionsAndSourcefileLineIncidentCounterValues[][])ArrayUtils.create(n -> new IInstructionsAndSourcefileLineIncidentCounterValues[n][], (int)numberOfDataPointIndexesByEventId.length, i -> new IInstructionsAndSourcefileLineIncidentCounterValues[numberOfDataPointIndexesByEventId[i]]);
        this.valuesByDataPointIndex = valuesByDataPointIndex;
        this.instructionIndexToSourceFileLineMapIndex = new int[instructionsFile.getCount()];
        instructionsFile.forEachInstructionGetSourceInfo(new InstructionToSourceLineIndexBuilder(this.instructionIndexToSourceFileLineMapIndex, sourcefileLineMap));
        int[] minMax = new int[]{-1, -1};
        this.sourceFileLineMapIndexToFunctionIndex = new int[sourcefileLineMap.size()];
        sourcefileLineMap.forEachIndexGetFunctionIndex((index, functionIndex) -> {
            this.sourceFileLineMapIndexToFunctionIndex[index] = functionIndex;
            if (functionIndex >= 0) {
                int currentMin = minMax[0];
                int currentMax = minMax[1];
                if (currentMin < 0 || currentMin > functionIndex) {
                    nArray[0] = functionIndex;
                }
                if (currentMax < 0 || currentMax < functionIndex) {
                    nArray[1] = functionIndex;
                }
            }
        });
        this.minFunctionId = Math.max(0, minMax[0]);
        this.numFunctionIds = minMax[1] >= 0 ? minMax[1] - this.minFunctionId + 1 : 0;
    }

    @Override
    public synchronized void close() throws IOException {
        int e = 0;
        while (e < this.valuesByDataPointIndex.length) {
            IInstructionsAndSourcefileLineIncidentCounterValues[] subarray = this.valuesByDataPointIndex[e];
            int d = 0;
            while (d < subarray.length) {
                IInstructionsAndSourcefileLineIncidentCounterValues values = subarray[d];
                subarray[d] = null;
                if (values instanceof Closeable) {
                    try {
                        ((Closeable)((Object)values)).close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                ++d;
            }
            ++e;
        }
    }

    @Override
    public @NonNull InstructionsAndSourcefileLineIncidentCounterAccumulator createAccumulator(int eventId, int dataPointIndex) {
        return new InstructionsAndSourcefileLineIncidentCounterAccumulator(eventId, dataPointIndex, this.instructionsFile.getCount(), this.sourcefileLineMap.size(), this.numFunctionIds, this::mapInstructionIndexToSourceIndex, this::mapSourceIndexToFunctionIndex, this::setValues);
    }

    @Override
    public @NonNull IInstructionCounterInstructionCounterSet getCounters(final @NonNull IInstructionsFile.IInstructionsFileEntry entry) {
        final int index = entry.getIndex();
        return new IInstructionCounterInstructionCounterSet(){

            @Override
            public long getCounterValue(int eventId, int dataPointIndex) {
                return InstructionsAndSourcefileLineCounterViews.this.getInstructionCounterValue(eventId, dataPointIndex, index);
            }

            @Override
            public @NonNull IInstructionsFile.IInstructionsFileEntry getInstruction() {
                return entry;
            }
        };
    }

    @Override
    public @NonNull IInstructionCounterInstructionCounterSet getCounters(int index) {
        @NonNull IInstructionsFile.IInstructionsFileEntry entry = this.instructionsFile.getEntry(index);
        return this.getCounters(entry);
    }

    @Override
    public @NonNull IInstructionsFile.IInstructionsFileEntry getInstruction(int index) {
        return this.instructionsFile.getEntry(index);
    }

    @Override
    public @Nullable IInstructionCounterSourcefileView getSourceLineView(final @NonNull SourceFile file, final int line) {
        final int sourceFileLineMapIndex = this.sourcefileLineMap.indexOf(file, line);
        if (sourceFileLineMapIndex < 0) {
            return null;
        }
        final @Nullable IFunction function = this.sourcefileLineMap.getFunction(sourceFileLineMapIndex);
        if (function == null) {
            assert (false);
            return null;
        }
        final int functionIndex = this.mapSourceIndexToFunctionIndex(sourceFileLineMapIndex);
        assert (functionIndex >= 0);
        final @NonNull IInstructionCounterSourceLineCounterSet functionCounters = new IInstructionCounterSourceLineCounterSet(){

            @Override
            public long getCounterValue(int eventId, int dataPointIndex) {
                return InstructionsAndSourcefileLineCounterViews.this.getSourceFileLineCounterAccumulatedFunctionValue(eventId, dataPointIndex, functionIndex);
            }
        };
        final @NonNull IInstructionCounterSourceLineFunctionView functionView = new IInstructionCounterSourceLineFunctionView(){

            @Override
            public @NonNull IInstructionCounterSourceLineCounterSet getCounterSet() {
                return functionCounters;
            }

            @Override
            public @NonNull IFunction getFunction() {
                return function;
            }
        };
        final @NonNull IInstructionCounterSourceLineCounterSet counters = new IInstructionCounterSourceLineCounterSet(){

            @Override
            public long getCounterValue(int eventId, int dataPointIndex) {
                return InstructionsAndSourcefileLineCounterViews.this.getSourceFileLineCounterValue(eventId, dataPointIndex, sourceFileLineMapIndex);
            }
        };
        return new IInstructionCounterSourcefileView(){

            @Override
            public @NonNull IInstructionCounterSourceLineCounterSet getCounters() {
                return counters;
            }

            @Override
            public @NonNull IInstructionCounterSourceLineFunctionView getFunctionView() {
                return functionView;
            }

            @Override
            public int getLine() {
                return line;
            }

            @Override
            public @NonNull SourceFile getSourceFile() {
                return file;
            }
        };
    }

    @Override
    public int numberOfInstructions() {
        return this.instructionsFile.getCount();
    }

    protected final long getInstructionCounterValue(int eventId, int dataPointIndex, int instructionIndex) {
        IInstructionsAndSourcefileLineIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.getInstructionCount(instructionIndex);
    }

    protected final long getSourceFileLineCounterAccumulatedFunctionValue(int eventId, int dataPointIndex, int functionIndex) {
        IInstructionsAndSourcefileLineIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.getFunctionCumulativeSourceFileLineCount(functionIndex);
    }

    protected final long getSourceFileLineCounterValue(int eventId, int dataPointIndex, int sourceFileLineMapIndex) {
        IInstructionsAndSourcefileLineIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.getSourceFileLineCount(sourceFileLineMapIndex);
    }

    protected synchronized void setValues(int eventId, int dataPointIndex, @NonNull InMemoryInstructionsAndSourcefileLineIncidentCounterValues values) throws IOException {
        this.valuesByDataPointIndex[eventId][dataPointIndex] = this.valueMapper.map(eventId, dataPointIndex, this.valuesByDataPointIndex[eventId][dataPointIndex], values);
    }

    private int mapFunctionIdToFunctionCounterIndex(int functionId) {
        return functionId >= 0 ? functionId - this.minFunctionId : -1;
    }

    private int mapInstructionIndexToSourceIndex(int index) {
        return this.instructionIndexToSourceFileLineMapIndex[index];
    }

    private int mapSourceIndexToFunctionIndex(int sourceIndex) {
        int functionId = this.sourceFileLineMapIndexToFunctionIndex[sourceIndex];
        return this.mapFunctionIdToFunctionCounterIndex(functionId);
    }

    public static class DefaultValueMapper
    implements IValueMapper {
        private static final long MAX_ENTRIES_FOR_IN_MEMORY_STORAGE = 1024L;
        private final boolean alwaysInMemory;
        private final @NonNull IFileStreamFactory fileStreamFactory;

        public DefaultValueMapper(boolean alwaysInMemory, @NonNull IFileStreamFactory fileStreamFactory) {
            this.alwaysInMemory = alwaysInMemory;
            this.fileStreamFactory = fileStreamFactory;
        }

        @Override
        public @NonNull IInstructionsAndSourcefileLineIncidentCounterValues map(int eventId, int dataPointIndex, @Nullable IInstructionsAndSourcefileLineIncidentCounterValues old, @NonNull InMemoryInstructionsAndSourcefileLineIncidentCounterValues values) throws IOException {
            long n = values.functionCumulativeSourceFileLineCount.length + values.instructionCount.length + values.sourceFileLineCount.length;
            if (old != null) {
                return old.replace(values);
            }
            if (n < 1024L || this.alwaysInMemory) {
                return values;
            }
            return new OnDiskInstructionsAndSourcefileLineIncidentCounterValues((IThrowingFunction<String, SeekableByteChannel, IOException>)((IThrowingFunction)name -> this.fileStreamFactory.create((String)name, eventId, dataPointIndex)), values.instructionCount, values.sourceFileLineCount, values.functionCumulativeSourceFileLineCount);
        }

        @FunctionalInterface
        public static interface IFileStreamFactory {
            public @NonNull SeekableByteChannel create(@NonNull String var1, int var2, int var3) throws IOException;
        }
    }

    @FunctionalInterface
    public static interface IValueMapper {
        public @NonNull IInstructionsAndSourcefileLineIncidentCounterValues map(int var1, int var2, @Nullable IInstructionsAndSourcefileLineIncidentCounterValues var3, @NonNull InMemoryInstructionsAndSourcefileLineIncidentCounterValues var4) throws IOException;
    }

    public static final class InstructionToSourceLineIndexBuilder
    implements IRawInstructionsFile.IInstructionSourceLineInfoConsumer {
        private int lastPosition = -1;
        private @Nullable SourceFile lastSourceFile = null;
        private int lastSourceLine = 0;
        private final int @NonNull [] map;
        private final @NonNull ISourcefileLineMap sourceLookup;

        public InstructionToSourceLineIndexBuilder(int @NonNull [] map, @NonNull ISourcefileLineMap sourceLookup) {
            this.sourceLookup = sourceLookup;
            this.map = map;
        }

        @Override
        public void accept(int index, @Nullable SourceFile sourceFile, int line) {
            assert (index >= 0 && index < this.map.length);
            if (sourceFile == null) {
                this.map[index] = -1;
            } else if (sourceFile == this.lastSourceFile && line == this.lastSourceLine) {
                this.map[index] = this.lastPosition;
            } else {
                int position = this.sourceLookup.indexOf(sourceFile, line);
                this.lastSourceFile = sourceFile;
                this.lastSourceLine = line;
                this.lastPosition = position;
                this.map[index] = position;
            }
        }
    }
}

