/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionIncidentCounterAccumulator;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.impl.RecomputeRangeProperties;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.instructionandsource.InstructionsAndSourcefileLineIncidentCounterAccumulator;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import gnu.trove.map.TIntLongMap;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;

public class RecomputeRange
implements Callable<Void> {
    private final int dataPointIndex;
    private final @NonNull IIncidentCounterDataSource dataSouce;
    private final long endTick;
    private final int eventId;
    private final @NonNull RecomputeRangeProperties properties;
    private final long startTick;

    public RecomputeRange(@NonNull RecomputeRangeProperties properties, @NonNull IIncidentCounterDataSource dataSouce, int eventId, int dataPointIndex, long startTick, long endTick) {
        this.properties = properties;
        this.dataSouce = dataSouce;
        this.eventId = eventId;
        this.dataPointIndex = dataPointIndex;
        this.startTick = startTick;
        this.endTick = endTick;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        @NonNull ICallPathAndFunctionCounterViews callPathsAndFunctionsCounters = this.properties.getCallPathsAndFunctions();
        @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews = this.properties.getInstructionAndSourceLineCounterViews();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            CallPathAndFunctionIncidentCounterAccumulator callPathsAccumulator = callPathsAndFunctionsCounters.createAccumulator(this.eventId, this.dataPointIndex);
            try {
                try (InstructionsAndSourcefileLineIncidentCounterAccumulator instructionsAccumulator = instructionAndSourceLineCounterViews.createAccumulator(this.eventId, this.dataPointIndex);){
                    this.dataSouce.loadRange(true, this.startTick, this.endTick, (cTime, iTime) -> {
                        callPathsAccumulator.addSelection((TIntLongMap)cTime);
                        instructionsAccumulator.addSelection((TIntLongMap)iTime);
                    });
                }
                if (callPathsAccumulator == null) return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (callPathsAccumulator == null) throw throwable;
                callPathsAccumulator.close();
                throw throwable;
            }
            callPathsAccumulator.close();
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

