/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.impl.RecomputeRangeProperties;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RecomputeCSMSamples
implements Callable<List<SamplesData>> {
    private final @NonNull IIncidentCounterDataSource dataSouce;
    private final long endTick;
    private final @NonNull RecomputeRangeProperties properties;
    private final long startTick;

    private static void addSelection(@NonNull IInstructionCounterCallPaths callPathsFile, @NonNull Map<@NonNull IInstructionCounterFunctionView, @NonNull SamplesData> functionMap, @Nullable TIntLongMap samples) {
        if (samples != null) {
            TIntLongIterator i = samples.iterator();
            while (i.hasNext()) {
                i.advance();
                int key = i.key();
                long value = i.value();
                @Nullable ICallPath callPath = callPathsFile.getCallPathByID(key);
                if (callPath == null) continue;
                @NonNull IInstructionCounterFunctionView function = (IInstructionCounterFunctionView)NullChecking.neverNull((Object)callPath.getFunction());
                SamplesData samplesData = functionMap.get(function);
                if (samplesData != null) {
                    samplesData.add(callPath, value);
                    continue;
                }
                samplesData = new SamplesData(callPath, value);
                functionMap.put(function, samplesData);
            }
        }
    }

    public RecomputeCSMSamples(@NonNull RecomputeRangeProperties properties, @NonNull IIncidentCounterDataSource dataSouce, long startTick, long endTick) {
        this.properties = properties;
        this.dataSouce = dataSouce;
        this.startTick = startTick;
        this.endTick = endTick;
    }

    @Override
    public @NonNull List<@NonNull SamplesData> call() throws Exception {
        @NonNull HashMap<@NonNull K, @NonNull V> functionMap = new HashMap();
        @NonNull IInstructionCounterCallPaths callPathsFile = this.properties.getCallPaths();
        this.dataSouce.loadRange(false, this.startTick, this.endTick, (cTime, iTime) -> RecomputeCSMSamples.addSelection(callPathsFile, functionMap, cTime));
        ArrayList<@NonNull SamplesData> samples = new ArrayList<SamplesData>(functionMap.values());
        Collections.sort(samples);
        return samples;
    }
}

