/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.common.model.icounters.IRatioInstructionCounterDataPoint;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.RatioValue;
import com.arm.utils.ArrayUtils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterRatioColumn<T>
implements IInstructionCounterRatioColumn<T> {
    protected final @NonNull IInstructionCounterSource instructionCounterSource;
    protected final long @NonNull [] maxValues;
    protected final @NonNull InstructionCounterRatioNumberSubColumn<T> @NonNull [] subColumns;
    private final @NonNull String description;
    private final @NonNull String title;

    public InstructionCounterRatioColumn(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull String title, @NonNull String description, @NonNull List<? extends @NonNull IRatioInstructionCounterDataPoint> dataPoints, int @Nullable [] dataPointIDsShownByDefault) {
        this.instructionCounterSource = instructionCounterSource;
        this.title = title;
        this.description = description;
        @NonNull InstructionCounterRatioNumberSubColumn @NonNull [] subColumns = new InstructionCounterRatioNumberSubColumn[dataPoints.size()];
        this.subColumns = subColumns;
        this.maxValues = new long[subColumns.length];
        int i = 0;
        while (i < subColumns.length) {
            @NonNull IRatioInstructionCounterDataPoint dataPoint = dataPoints.get(i);
            @NonNull String name = dataPoint.getName();
            @Nullable Integer colourRGB = dataPoint.getColourRGB();
            @NonNull String numberTitle = name;
            @NonNull String numberDescription = name;
            boolean visibleByDefault = dataPointIDsShownByDefault == null || ArrayUtils.indexOf((int[])dataPointIDsShownByDefault, (int)dataPoint.getID()) >= 0;
            subColumns[i] = new InstructionCounterRatioNumberSubColumn(this, i, numberTitle, numberDescription, name, colourRGB, visibleByDefault);
            this.maxValues[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    @Override
    public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
        return visitor.displayAsRatio(data, this);
    }

    @Override
    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public long @NonNull [] getMaxPossibleDisplayValues() {
        return this.maxValues;
    }

    @Override
    public @Nullable IInstructionCounterColumn<T> getParentColumn() {
        return null;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public @NonNull String getTitleTooltip() {
        return this.description;
    }

    @Override
    public @NonNull String getValueTooltip(@NonNull T value) {
        return this.getValueName(value);
    }

    @Override
    public @NonNull RatioValue @Nullable [] mapRatioValue(@NonNull T value) {
        @NonNull RatioValue @NonNull [] values = new RatioValue[this.subColumns.length];
        boolean anyNonNull = false;
        int i = 0;
        while (i < this.subColumns.length) {
            @Nullable Long v = this.getDataPointValue(value, this.subColumns[i].dataPointIndex);
            values[i] = new RatioValue(this.subColumns[i].getTitle(), v != null ? v : 0L, this.subColumns[i].getColour());
            anyNonNull |= v != null;
            ++i;
        }
        return anyNonNull ? values : null;
    }

    @Override
    public @NonNull IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn<T> @NonNull [] valueSubColumns() {
        return this.subColumns;
    }

    protected abstract @Nullable Long getDataPointValue(@NonNull T var1, int var2);

    protected @NonNull String getValueName(@NonNull T value) {
        return this.title;
    }

    protected static final class InstructionCounterRatioNumberSubColumn<T>
    implements IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn<T> {
        private static final @NonNull String FORMAT_VALUE_DESCRIPTION = "Value \"{0}\" of \"{1}\", where \"{1}\" is {2}";
        protected final @Nullable Integer colourRGB;
        protected final int dataPointIndex;
        protected final @NonNull String numberToolTip;
        protected final @NonNull InstructionCounterRatioColumn<T> parent;
        protected final @NonNull String ratioName;

        public InstructionCounterRatioNumberSubColumn(@NonNull InstructionCounterRatioColumn<T> parent, int dataPointIndex, @NonNull String ratioTitle, @NonNull String ratioDescription, @NonNull String ratioName, @Nullable Integer colourRGB, boolean visibleByDefault) {
            this.parent = parent;
            this.dataPointIndex = dataPointIndex;
            this.numberToolTip = MessageFormat.format(FORMAT_VALUE_DESCRIPTION, ratioName, ratioTitle, ratioDescription);
            this.ratioName = ratioName;
            this.colourRGB = colourRGB;
        }

        @Override
        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
            return visitor.displayAsNumber(data, this);
        }

        @Override
        public @Nullable Integer getColour() {
            return this.colourRGB;
        }

        @Override
        public @NonNull IInstructionCounterSource getInstructionCounterSource() {
            return this.parent.instructionCounterSource;
        }

        @Override
        public long getMaxPossibleDisplayValue() {
            return this.parent.maxValues[this.dataPointIndex];
        }

        @Override
        public @Nullable IInstructionCounterColumn<T> getParentColumn() {
            return this.parent;
        }

        @Override
        public @NonNull String getRatioName() {
            return this.ratioName;
        }

        @Override
        public @NonNull String getTitle() {
            return this.ratioName;
        }

        @Override
        public @NonNull String getTitleTooltip() {
            return this.numberToolTip;
        }

        @Override
        public @NonNull String getValueTooltip(@NonNull T value) {
            return this.parent.getValueName(value);
        }

        @Override
        public @Nullable Long mapToNumber(@NonNull T data) {
            return this.parent.getDataPointValue(data, this.dataPointIndex);
        }
    }
}

