/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.report.model.icounters.HistogramDataPoint;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterHistogramColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterHistogramColumn<T>
implements IInstructionCounterHistogramColumn<T> {
    private final @Nullable Integer colourRGB;
    private final @NonNull String description;
    private final @NonNull HistogramDataPoint @NonNull [] histogramDataPoints;
    private final @NonNull IInstructionCounterSource instructionCounterSource;
    private final long @NonNull [] maxDisplayValues;
    private final @NonNull String title;
    private final @NonNull String units;

    public InstructionCounterHistogramColumn(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull String title, @NonNull String description, @NonNull String units, @Nullable Integer colourRGB, @NonNull HistogramDataPoint @NonNull [] histogramDataPoints) {
        this.instructionCounterSource = instructionCounterSource;
        this.title = title;
        this.description = description;
        this.colourRGB = colourRGB;
        this.units = units;
        this.histogramDataPoints = histogramDataPoints;
        this.maxDisplayValues = HistogramDataPoint.calculateAbsoluteBaseValues(histogramDataPoints);
    }

    @Override
    public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
        return visitor.displayAsHistogram(data, this);
    }

    @Override
    public @Nullable Integer getColour() {
        return this.colourRGB;
    }

    @Override
    public @NonNull HistogramDataPoint @NonNull [] getDatapoints() {
        return this.histogramDataPoints;
    }

    @Override
    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public long @NonNull [] getMaxPossibleDisplayValues() {
        return this.maxDisplayValues;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public @NonNull String getTitleTooltip() {
        return this.description;
    }

    @Override
    public @NonNull String getValueTooltip(@NonNull T value) {
        return "";
    }

    @Override
    public @NonNull String getUnits() {
        return this.units;
    }
}

