/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.FunctionCounters;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.IInstructionCounterFunctionCounterSource;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class FunctionView
implements IInstructionCounterFunctionView {
    private final @NonNull List<@NonNull ICallPath> associatedCallPaths = new ArrayList<ICallPath>();
    private final @NonNull IInstructionCounterFunctionCounterSet counters;
    private final @NonNull IFunction function;

    public FunctionView(@NonNull IFunction function, @NonNull IInstructionCounterFunctionCounterSource source, int sourceIndex) {
        this.function = function;
        this.counters = new FunctionCounters(source, sourceIndex);
    }

    public void associateCallPath(@NonNull ICallPath link) {
        this.associatedCallPaths.add(link);
    }

    @Override
    public int compareTo(IInstructionCounterFunctionView o) {
        return this.function.compareTo(o.getFunction());
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
        collection.addAll(this.associatedCallPaths);
    }

    @Override
    public void extractDisassemblyLines(BitSet set) {
        this.function.extractDisassemblyLines(set);
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        this.function.extractFunctions(collection);
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        this.function.extractSourceFiles(collection);
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        this.function.extractSourceReferences(collection);
    }

    @Override
    public @NonNull List<@NonNull ICallPath> getAssociatedCallPaths() {
        return this.associatedCallPaths;
    }

    @Override
    public @NonNull IInstructionCounterFunctionCounterSet getCounterSet() {
        return this.counters;
    }

    @Override
    public @NonNull IFunction getFunction() {
        return this.function;
    }
}

