/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionIncidentCounterValues;
import com.arm.streamline.report.model.icounters.impl.IIncidentCounterAccumulatorResultConsumer;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathAndFunctionIncidentCounterAccumulator
implements Closeable {
    private final long @NonNull [] callpathCumulativeCount;
    private final @NonNull IntUnaryOperator callPathIdToIndexMapper;
    private final long @NonNull [] callpathSelfCount;
    private final int dataPointIndex;
    private final int eventId;
    private final long @NonNull [] functionCumulativeCount;
    private final long @NonNull [] functionSelfCount;
    private final @NonNull IntUnaryOperator indexToFunctionIndexMapper;
    private final @NonNull IntUnaryOperator indexToParentIndexMapper;
    private final @NonNull IIncidentCounterAccumulatorResultConsumer<CallPathAndFunctionIncidentCounterValues> resultConsumer;
    private long total;
    private long maximumCallPathSelfValue;
    private long maximumFunctionSelfValue;

    public CallPathAndFunctionIncidentCounterAccumulator(int eventId, int dataPointIndex, int callPathCount, int functionCount, @NonNull IntUnaryOperator callPathIdToIndexMapper, @NonNull IntUnaryOperator indexToFunctionIndexMapper, @NonNull IntUnaryOperator indexToParentIndexMapper, @NonNull IIncidentCounterAccumulatorResultConsumer<CallPathAndFunctionIncidentCounterValues> resultConsumer) {
        this.eventId = eventId;
        this.dataPointIndex = dataPointIndex;
        this.callPathIdToIndexMapper = callPathIdToIndexMapper;
        this.indexToFunctionIndexMapper = indexToFunctionIndexMapper;
        this.indexToParentIndexMapper = indexToParentIndexMapper;
        this.resultConsumer = resultConsumer;
        this.callpathSelfCount = new long[callPathCount];
        this.callpathCumulativeCount = new long[callPathCount];
        this.functionSelfCount = new long[functionCount];
        this.functionCumulativeCount = new long[functionCount];
    }

    public void addSelection(int id, long value) {
        int callPathIndex = this.callPathIdToIndexMapper.applyAsInt(id);
        int functionIndex = this.indexToFunctionIndexMapper.applyAsInt(callPathIndex);
        this.total += value;
        int n = callPathIndex;
        this.callpathSelfCount[n] = this.callpathSelfCount[n] + value;
        this.maximumCallPathSelfValue = Math.max(this.maximumCallPathSelfValue, this.callpathSelfCount[callPathIndex]);
        if (functionIndex >= 0) {
            int n2 = functionIndex;
            this.functionSelfCount[n2] = this.functionSelfCount[n2] + value;
            this.maximumFunctionSelfValue = Math.max(this.maximumFunctionSelfValue, this.functionSelfCount[functionIndex]);
        }
        int pIndex = callPathIndex;
        int pFunctionIndex = functionIndex;
        while (pIndex >= 0) {
            int n3 = pIndex;
            this.callpathCumulativeCount[n3] = this.callpathCumulativeCount[n3] + value;
            if (pFunctionIndex >= 0) {
                int n4 = pFunctionIndex;
                this.functionCumulativeCount[n4] = this.functionCumulativeCount[n4] + value;
            }
            int n5 = pFunctionIndex = (pIndex = this.indexToParentIndexMapper.applyAsInt(pIndex)) >= 0 ? this.indexToFunctionIndexMapper.applyAsInt(pIndex) : -1;
        }
    }

    public void addSelection(@Nullable TIntLongMap samples) {
        if (samples != null) {
            TIntLongIterator iterator = samples.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                int id = iterator.key();
                long value = iterator.value();
                this.addSelection(id, value);
            }
        }
    }

    @Override
    public void close() throws IOException {
        CallPathAndFunctionIncidentCounterValues result = new CallPathAndFunctionIncidentCounterValues(this.callpathSelfCount, this.callpathCumulativeCount, this.functionSelfCount, this.functionCumulativeCount, this.total, this.maximumCallPathSelfValue, this.maximumFunctionSelfValue);
        this.resultConsumer.accept(this.eventId, this.dataPointIndex, result);
    }
}

