/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPathCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionIncidentCounterAccumulator;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathAndFunctionIncidentCounterValues;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPathCounters;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.FunctionView;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathAndFunctionCounterViews
implements ICallPathAndFunctionCounterViews {
    private final @NonNull Set<@NonNull FunctionView> activeFunctionViews;
    private final int @NonNull [] callPathIndexToFunctionIndex;
    private final int @NonNull [] callPathIndexToParentIndex;
    private final @NonNull BitSet callPathIndexValid;
    private final @NonNull BitSet functionIndexAssociatedWithCallPath;
    private final @NonNull TIntObjectMap<FunctionView> functionIndexMap = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull BitSet functionIndexValid;
    private final @NonNull Map<@NonNull IFunction, @NonNull FunctionView> functionMap;
    private final @NonNull AtomicReferenceArray<@Nullable Long> maximumCallPathSelfValue;
    private final @NonNull AtomicReferenceArray<@Nullable Long> maximumFunctionSelfValue;
    private final int minCallPathId;
    private final int minFunctionId;
    private final int numCallPathIds;
    private final int numFunctionIds;
    private final @Nullable CallPathAndFunctionIncidentCounterValues @NonNull [] @NonNull [] valuesByDataPointIndex;

    public CallPathAndFunctionCounterViews(int @NonNull [] callPathIds, @NonNull IInstructionCounterFunctions functionsFile, int @NonNull [] numberOfDataPointIndexesByEventId) {
        assert (numberOfDataPointIndexesByEventId.length >= 0);
        @Nullable CallPathAndFunctionIncidentCounterValues @NonNull [] @NonNull [] valuesByDataPointIndex = (CallPathAndFunctionIncidentCounterValues[][])ArrayUtils.create(n -> new CallPathAndFunctionIncidentCounterValues[n][], (int)numberOfDataPointIndexesByEventId.length, i -> new CallPathAndFunctionIncidentCounterValues[numberOfDataPointIndexesByEventId[i]]);
        this.valuesByDataPointIndex = valuesByDataPointIndex;
        this.maximumCallPathSelfValue = new AtomicReferenceArray(numberOfDataPointIndexesByEventId.length);
        this.maximumFunctionSelfValue = new AtomicReferenceArray(numberOfDataPointIndexesByEventId.length);
        if (callPathIds.length > 0) {
            int minCallPathId = Integer.MAX_VALUE;
            int maxCallPathId = 0;
            Object object = callPathIds;
            int n2 = callPathIds.length;
            int n3 = 0;
            while (n3 < n2) {
                int id = object[n3];
                minCallPathId = Math.min(minCallPathId, id);
                maxCallPathId = Math.max(maxCallPathId, id);
                ++n3;
            }
            assert (minCallPathId <= maxCallPathId);
            this.minCallPathId = minCallPathId;
            this.numCallPathIds = maxCallPathId - minCallPathId + 1;
            if (functionsFile.size() > 0) {
                int minFunctionId = Integer.MAX_VALUE;
                int maxFunctionId = 0;
                object = functionsFile.iterator();
                while (object.hasNext()) {
                    IFunction function = (IFunction)object.next();
                    int id = function.getIndex();
                    minFunctionId = Math.min(minFunctionId, id);
                    maxFunctionId = Math.max(maxFunctionId, id);
                }
                assert (minFunctionId <= maxFunctionId);
                this.minFunctionId = minFunctionId;
                this.numFunctionIds = maxFunctionId - minFunctionId + 1;
            } else {
                this.minFunctionId = 0;
                this.numFunctionIds = 0;
            }
            this.functionIndexAssociatedWithCallPath = new BitSet(this.numFunctionIds);
            this.functionIndexValid = new BitSet(this.numFunctionIds);
            this.callPathIndexValid = new BitSet(this.numCallPathIds);
            this.callPathIndexToFunctionIndex = new int[this.numCallPathIds];
            this.callPathIndexToParentIndex = new int[this.numCallPathIds];
            Arrays.fill(this.callPathIndexToFunctionIndex, -1);
            Arrays.fill(this.callPathIndexToParentIndex, -1);
            @NonNull List<@NonNull FunctionView> functionViews = functionsFile.stream().map(this::createFunctionView).collect(Collectors.toList());
            this.functionMap = functionViews.stream().collect(Collectors.toMap(FunctionView::getFunction, Function.identity()));
            functionViews.forEach(f -> {
                Object object = this.functionIndexMap.put(f.getFunction().getIndex(), f);
            });
            this.activeFunctionViews = new HashSet<FunctionView>();
        } else {
            this.minCallPathId = 0;
            this.numCallPathIds = 0;
            this.minFunctionId = 0;
            this.numFunctionIds = 0;
            this.functionIndexAssociatedWithCallPath = new BitSet(0);
            this.functionIndexValid = new BitSet(0);
            this.callPathIndexValid = new BitSet(0);
            this.callPathIndexToFunctionIndex = new int[0];
            this.callPathIndexToParentIndex = new int[0];
            this.activeFunctionViews = Collections.emptySet();
            this.functionMap = Collections.emptyMap();
        }
    }

    @Override
    public int calculateLargestFunctionCallChainCount() {
        int largestFunctionCallChainCount = 0;
        for (IInstructionCounterFunctionView iInstructionCounterFunctionView : this.activeFunctionViews) {
            @NonNull IFunction function = iInstructionCounterFunctionView.getFunction();
            function.getSourceFile().add(function);
            int intSize = iInstructionCounterFunctionView.getAssociatedCallPaths().size();
            if (largestFunctionCallChainCount >= intSize) continue;
            largestFunctionCallChainCount = intSize;
        }
        return largestFunctionCallChainCount;
    }

    @Override
    public @NonNull IInstructionCounterCallPathCounterSet create(@NonNull ICallPath callPath) {
        int functionIndex;
        int id = callPath.getID();
        @Nullable ICallPath parentCallPath = callPath.getParentCallChainLink();
        @Nullable IInstructionCounterFunctionView function = callPath.getFunction();
        int index = this.mapIndex(id);
        int parentIndex = parentCallPath != null ? this.mapIndex(parentCallPath.getID()) : -1;
        int n = functionIndex = function != null ? this.mapFunctionIndex(function.getFunction().getIndex()) : -1;
        assert (index != parentIndex);
        assert (!this.callPathIndexValid.get(index));
        assert (functionIndex < 0 || this.functionIndexValid.get(functionIndex));
        assert (parentIndex < 0 || this.callPathIndexValid.get(parentIndex));
        this.callPathIndexValid.set(index);
        this.callPathIndexToFunctionIndex[index] = functionIndex;
        this.callPathIndexToParentIndex[index] = parentIndex;
        if (function != null) {
            assert (functionIndex >= 0);
            @NonNull FunctionView functionView = (FunctionView)NullChecking.neverNull((Object)this.functionMap.get(function.getFunction()));
            functionView.associateCallPath(callPath);
            this.activeFunctionViews.add(functionView);
            this.functionIndexAssociatedWithCallPath.set(functionIndex);
        }
        return new CallPathCounters(this, index);
    }

    @Override
    public @NonNull CallPathAndFunctionIncidentCounterAccumulator createAccumulator(int eventId, int dataPointIndex) {
        return new CallPathAndFunctionIncidentCounterAccumulator(eventId, dataPointIndex, this.numCallPathIds, this.numFunctionIds, this::mapIndex, this::mapIndexToFunctionIndex, this::mapIndexToParentIndex, this::setValues);
    }

    @Override
    public @NonNull IInstructionCounterFunctionView forFunction(@NonNull IFunction function) {
        @Nullable FunctionView result = this.functionMap.get(function);
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    @Override
    public long getCallPathCumulativeValue(int eventId, int dataPointIndex, int index) {
        if (index < 0 || index >= this.numCallPathIds || !this.callPathIndexValid.get(index)) {
            throw new IllegalArgumentException();
        }
        CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.callPathCumulativeCount[index];
    }

    @Override
    public long getCallPathSelfValue(int eventId, int dataPointIndex, int index) {
        if (index < 0 || index >= this.numCallPathIds || !this.callPathIndexValid.get(index)) {
            throw new IllegalArgumentException();
        }
        CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.callPathSelfCount[index];
    }

    @Override
    public long getFunctionCumulativeValue(int eventId, int dataPointIndex, int index) {
        if (index < 0 || index >= this.numFunctionIds || !this.functionIndexValid.get(index)) {
            throw new IllegalArgumentException();
        }
        if (!this.functionIndexAssociatedWithCallPath.get(index)) {
            return 0L;
        }
        CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.functionCumulativeCount[index];
    }

    @Override
    public long getFunctionSelfValue(int eventId, int dataPointIndex, int index) {
        if (index < 0 || index >= this.numFunctionIds || !this.functionIndexValid.get(index)) {
            throw new IllegalArgumentException();
        }
        if (!this.functionIndexAssociatedWithCallPath.get(index)) {
            return 0L;
        }
        CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.functionSelfCount[index];
    }

    @Override
    public @Nullable IInstructionCounterFunctionView getFunctionViewById(int id) {
        return (IInstructionCounterFunctionView)this.functionIndexMap.get(id);
    }

    @Override
    public long getMaximumCallPathSelfValue(int eventId) {
        return this.getMaximumValue(eventId, this.maximumCallPathSelfValue, x -> x.maximumCallPathSelfValue);
    }

    @Override
    public long getMaximumFunctionSelfValue(int eventId) {
        return this.getMaximumValue(eventId, this.maximumFunctionSelfValue, x -> x.maximumFunctionSelfValue);
    }

    @Override
    public long getMaximumCallPathSelfValue(int eventId, int dataPointIndex) {
        @Nullable CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.maximumCallPathSelfValue;
    }

    @Override
    public long getMaximumFunctionSelfValue(int eventId, int dataPointIndex) {
        @Nullable CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.maximumFunctionSelfValue;
    }

    @Override
    public long getTotal(int eventId, int dataPointIndex) {
        @Nullable CallPathAndFunctionIncidentCounterValues values = this.valuesByDataPointIndex[eventId][dataPointIndex];
        if (values == null) {
            return 0L;
        }
        return values.total;
    }

    @Override
    public boolean hasFunctionAnyData(@NonNull IFunction function) {
        int id = function.getIndex();
        int index = this.mapFunctionIndex(id);
        if (index < 0 || index >= this.numFunctionIds || !this.functionIndexValid.get(index)) {
            return false;
        }
        CallPathAndFunctionIncidentCounterValues[][] callPathAndFunctionIncidentCounterValuesArray = this.valuesByDataPointIndex;
        int n = this.valuesByDataPointIndex.length;
        int n2 = 0;
        while (n2 < n) {
            CallPathAndFunctionIncidentCounterValues[] values;
            CallPathAndFunctionIncidentCounterValues[] callPathAndFunctionIncidentCounterValuesArray2 = values = callPathAndFunctionIncidentCounterValuesArray[n2];
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                CallPathAndFunctionIncidentCounterValues value = callPathAndFunctionIncidentCounterValuesArray2[n4];
                if (value != null && value.functionSelfCount[index] != 0L) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public @NonNull Iterator<@NonNull IInstructionCounterFunctionView> iterator() {
        return Collections.unmodifiableSet(this.activeFunctionViews).iterator();
    }

    @Override
    public int size() {
        return this.activeFunctionViews.size();
    }

    protected void setValues(int eventId, int dataPointIndex, @NonNull CallPathAndFunctionIncidentCounterValues values) {
        this.valuesByDataPointIndex[eventId][dataPointIndex] = values;
        this.maximumCallPathSelfValue.set(eventId, null);
    }

    private @NonNull FunctionView createFunctionView(@NonNull IFunction function) {
        int id = function.getIndex();
        int index = this.mapFunctionIndex(id);
        assert (!this.functionIndexValid.get(index));
        this.functionIndexValid.set(index);
        return new FunctionView(function, this, index);
    }

    private long getMaximumValue(int eventId, @NonNull AtomicReferenceArray<@Nullable Long> maximumValues, @NonNull ToLongFunction<@NonNull CallPathAndFunctionIncidentCounterValues> maxGetter) {
        long max;
        do {
            Long result;
            if ((result = maximumValues.get(eventId)) != null) {
                return result;
            }
            max = 0L;
            CallPathAndFunctionIncidentCounterValues[] callPathAndFunctionIncidentCounterValuesArray = this.valuesByDataPointIndex[eventId];
            int n = callPathAndFunctionIncidentCounterValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                CallPathAndFunctionIncidentCounterValues values = callPathAndFunctionIncidentCounterValuesArray[n2];
                if (values != null) {
                    max = Math.max(max, maxGetter.applyAsLong(values));
                }
                ++n2;
            }
        } while (!maximumValues.compareAndSet(eventId, null, max));
        return max;
    }

    private int mapFunctionIndex(int id) {
        if (id < 0) {
            return -1;
        }
        int index = id - this.minFunctionId;
        if (index < 0 || index >= this.numFunctionIds) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    private int mapIndex(int id) {
        if (id < 0) {
            return -1;
        }
        int index = id - this.minCallPathId;
        if (index < 0 || index >= this.numCallPathIds) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    private int mapIndexToFunctionIndex(int index) {
        return this.callPathIndexToFunctionIndex[index];
    }

    private int mapIndexToParentIndex(int index) {
        return this.callPathIndexToParentIndex[index];
    }
}

