/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPathCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.IInstructionCounterCallPathCounterSetFactory;
import com.arm.streamline.report.model.icounters.io.ICallPathFactory;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPath
implements ICallPath {
    public static final @NonNull ICallPathFactory<CallPath> FACTORY = new ICallPathFactory<CallPath>(){

        @Override
        public @NonNull CallPath createForFunction(int id, @Nullable CallPath parent, @NonNull IInstructionCounterFunctionView function, @NonNull IInstructionCounterCallPathCounterSetFactory countersFactory) {
            return new CallPath(CallPathNodeType.FUNCTION, id, parent, null, null, null, function, countersFactory);
        }

        @Override
        public @NonNull CallPath createForUID(int id, @Nullable CallPath parent, int uid, @Nullable String name, @NonNull IInstructionCounterCallPathCounterSetFactory countersFactory) {
            return new CallPath(CallPathNodeType.UID, id, parent, null, uid, name, null, countersFactory);
        }

        @Override
        public @NonNull CallPath createForVmUID(int id, @Nullable CallPath parent, long vmUID, @Nullable String name, @NonNull IInstructionCounterCallPathCounterSetFactory countersFactory) {
            return new CallPath(CallPathNodeType.VMUID, id, parent, vmUID, null, name, null, countersFactory);
        }
    };
    private final @NonNull IInstructionCounterCallPathCounterSet counters;
    private final @Nullable String extraNameForLink;
    private final int mCallPathId;
    private @Nullable List<@NonNull ICallPath> mChildren;
    private final short mDepth;
    private @Nullable String mFullName;
    private final @Nullable IInstructionCounterFunctionView mFunction;
    private final @Nullable ICallPath mParent;
    private final int mStack;
    private final @NonNull CallPathNodeType mType;
    private final @Nullable Integer mUID;
    private final @Nullable Long mVmUID;

    protected CallPath(@NonNull CallPathNodeType type, int id, @Nullable CallPath parent, @Nullable Long vmUID, @Nullable Integer uid, @Nullable String extraNameForLink, @Nullable IInstructionCounterFunctionView function, @NonNull IInstructionCounterCallPathCounterSetFactory countersFactory) {
        this.extraNameForLink = extraNameForLink;
        this.mType = type;
        this.mCallPathId = id;
        this.mParent = parent;
        this.mVmUID = vmUID;
        this.mFunction = function;
        this.mUID = uid;
        this.mDepth = (short)(parent != null ? parent.mDepth + 1 : 0);
        if (parent != null) {
            parent.getMutablechildren().add(this);
        }
        int functionStack = function != null ? function.getFunction().getStackSize() : 0;
        int parentStack = parent != null ? parent.mStack : 0;
        this.mStack = functionStack > 0 ? functionStack + parentStack : parentStack;
        this.counters = countersFactory.create(this);
    }

    @Override
    public int compareTo(ICallPath other) {
        int typeOrder = this.compareTo(other.getType());
        if (typeOrder != 0) {
            return typeOrder;
        }
        return Integer.compare(this.mCallPathId, other.getID());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ICallPath) {
            ICallPath that = (ICallPath)obj;
            return this.mCallPathId == that.getID() && this.mType == that.getType();
        }
        return false;
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
        collection.add(this);
    }

    @Override
    public void extractDisassemblyLines(BitSet set) {
        if (this.mFunction != null) {
            this.mFunction.extractDisassemblyLines(set);
        }
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        if (this.mFunction != null) {
            collection.add(this.mFunction.getFunction());
        }
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        if (this.mFunction != null) {
            this.mFunction.extractSourceFiles(collection);
        }
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        if (this.mFunction != null) {
            this.mFunction.extractSourceReferences(collection);
        }
    }

    @Override
    public long getAddress() {
        ICallPath link = this.getFirstNonEmptyNode();
        if (link != null) {
            return ((IInstructionCounterFunctionView)NullChecking.neverNull((Object)link.getFunction())).getFunction().getAddress();
        }
        return 0L;
    }

    @Override
    public @NonNull List<@NonNull ICallPath> getChildren() {
        if (this.mChildren != null) {
            return this.mChildren;
        }
        return Collections.emptyList();
    }

    @Override
    public @NonNull IInstructionCounterCallPathCounterSet getCounters() {
        return this.counters;
    }

    @Override
    public int getDepth() {
        return this.mDepth;
    }

    @Override
    public @Nullable String getExtraNameForLink() {
        return this.extraNameForLink;
    }

    @Override
    public ICallPath getFirstNonEmptyNode() {
        if (!this.isStructureOnlyNode()) {
            return this;
        }
        @Nullable List<@NonNull ICallPath> children = this.mChildren;
        if (children != null && this.hasChildren()) {
            for (ICallPath child : children) {
                ICallPath result = child.getFirstNonEmptyNode();
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public String getFullName() {
        String mFullName = this.mFullName;
        if (mFullName == null) {
            StringBuilder buffer = new StringBuilder();
            this.makeFullName(buffer);
            this.mFullName = mFullName = buffer.toString();
        }
        return mFullName;
    }

    @Override
    public @Nullable IInstructionCounterFunctionView getFunction() {
        return this.mFunction;
    }

    @Override
    public int getID() {
        return this.mCallPathId;
    }

    @Override
    public int getLargestStackUsageInChain() {
        int largest = this.getStackSize();
        @Nullable List<@NonNull ICallPath> children = this.mChildren;
        if (children != null && this.hasChildren()) {
            for (ICallPath child : children) {
                int size = child.getLargestStackUsageInChain();
                if (size <= largest) continue;
                largest = size;
            }
        }
        return largest;
    }

    @Override
    public @NonNull ICallPath @NonNull [] getLinkPath() {
        @NonNull ICallPath @NonNull [] links = new ICallPath[this.mDepth + 1];
        int i = this.mDepth;
        ICallPath link = this;
        while (link != null) {
            links[i--] = link;
            link = link.getParentCallChainLink();
        }
        return links;
    }

    @Override
    public @NonNull String getName() {
        StringBuilder buffer = new StringBuilder();
        @Nullable String name = this.extraNameForLink;
        switch (this.mType) {
            case FUNCTION: {
                assert (this.mFunction != null);
                buffer.append(this.mFunction.getFunction().getName());
                break;
            }
            case UID: {
                if (name == null) break;
                buffer.append(name);
                break;
            }
            case VMUID: {
                assert (this.mVmUID != null);
                if (name != null) {
                    buffer.append("(").append(name).append(" #").append(this.mVmUID).append(")");
                    break;
                }
                buffer.append("(VM #").append(this.mVmUID).append(")");
                break;
            }
            default: {
                throw new AssertionError((Object)this.mType);
            }
        }
        return buffer.toString();
    }

    @Override
    public final @Nullable ICallPath getParentCallChainLink() {
        return this.mParent;
    }

    @Override
    public @Nullable ICallPath getRootNonStructureOnlyNode() {
        ICallPath node = this;
        CallPath root = null;
        while (node != null && !node.isStructureOnlyNode()) {
            root = node;
            node = node.getParentCallChainLink();
        }
        return root;
    }

    @Override
    public @Nullable ICallPath getRootUniqueProcess() {
        ICallPath node = this;
        while (node != null) {
            if (node.isProcessUID()) {
                return node;
            }
            node = node.getParentCallChainLink();
        }
        assert (this.mType == CallPathNodeType.VMUID);
        return null;
    }

    @Override
    public int getStackSize() {
        return this.mStack;
    }

    @Override
    public String getThreadName() {
        StringBuilder buffer = new StringBuilder();
        ICallPath root = this.getRootNonStructureOnlyNode();
        if (root != null) {
            ICallPath[] linkPath = root.getLinkPath();
            int i = 0;
            while (i < linkPath.length - 1) {
                buffer.append(linkPath[i]);
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public long getTotalSamples() {
        return this.counters.getTotalCounterValue(0, 0);
    }

    @Override
    public @NonNull CallPathNodeType getType() {
        return this.mType;
    }

    @Override
    public @Nullable Integer getUniqueID(boolean recurse) {
        switch (this.mType) {
            case FUNCTION: {
                @Nullable ICallPath parent = this.mParent;
                return recurse && parent != null ? parent.getUniqueID(true) : null;
            }
            case UID: {
                return (Integer)NullChecking.neverNull((Object)this.mUID);
            }
            case VMUID: {
                return null;
            }
        }
        throw new AssertionError((Object)this.mType);
    }

    @Override
    public @Nullable Long getVmUID(boolean recurse) {
        switch (this.mType) {
            case FUNCTION: 
            case UID: {
                @Nullable ICallPath parent = this.mParent;
                return recurse && parent != null ? parent.getVmUID(true) : null;
            }
            case VMUID: {
                return (Long)NullChecking.neverNull((Object)this.mVmUID);
            }
        }
        throw new AssertionError((Object)this.mType);
    }

    @Override
    public boolean hasChildren() {
        return this.mChildren != null && !this.mChildren.isEmpty();
    }

    public int hashCode() {
        return this.mCallPathId;
    }

    @Override
    public boolean hasUnknownStack() {
        if (this.mFunction != null && this.mFunction.getFunction().hasUnknownStack()) {
            return true;
        }
        ICallPath parent = this.getParentCallChainLink();
        return parent != null && parent.hasUnknownStack();
    }

    @Override
    public boolean isDescendantOf(Collection<ICallPath> potentialParents) {
        for (ICallPath potentialParent : potentialParents) {
            if (!this.isDescendantOf(potentialParent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDescendantOf(ICallPath potentialParent) {
        if (this.getDepth() <= potentialParent.getDepth()) {
            return false;
        }
        ICallPath ancestor = this.getParentCallChainLink();
        while (ancestor != null) {
            if (ancestor == potentialParent) {
                return true;
            }
            ancestor = ancestor.getParentCallChainLink();
        }
        return false;
    }

    @Override
    public boolean isProcessUID() {
        @Nullable ICallPath parent = this.mParent;
        return this.mType == CallPathNodeType.UID && (parent == null || parent.getType() == CallPathNodeType.VMUID);
    }

    @Override
    public boolean isStructureOnlyNode() {
        return this.mFunction == null;
    }

    @Override
    public boolean matches(Pattern pattern) {
        if (pattern.matcher(this.getName()).find()) {
            return true;
        }
        @Nullable List<@NonNull ICallPath> children = this.mChildren;
        if (children != null && this.hasChildren()) {
            for (ICallPath child : children) {
                if (!child.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @NonNull Iterable<@NonNull ICallPath> walkToRoot() {
        return () -> new Iterator<ICallPath>(){
            private ICallPath current;
            {
                this.current = CallPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public ICallPath next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                ICallPath path = this.current;
                this.current = this.current.getParentCallChainLink();
                return (ICallPath)NullChecking.neverNull((Object)path);
            }
        };
    }

    public String toString() {
        return this.getName();
    }

    @Override
    private int compareTo(@NonNull CallPathNodeType other) {
        switch (this.mType) {
            case VMUID: {
                switch (other) {
                    case FUNCTION: 
                    case UID: {
                        return -1;
                    }
                    case VMUID: {
                        return 0;
                    }
                }
                throw new AssertionError((Object)this.mType);
            }
            case UID: {
                switch (other) {
                    case FUNCTION: {
                        return -1;
                    }
                    case UID: {
                        return 0;
                    }
                    case VMUID: {
                        return 1;
                    }
                }
                throw new AssertionError((Object)this.mType);
            }
            case FUNCTION: {
                switch (other) {
                    case FUNCTION: {
                        return 0;
                    }
                    case UID: 
                    case VMUID: {
                        return 1;
                    }
                }
                throw new AssertionError((Object)this.mType);
            }
        }
        throw new AssertionError((Object)this.mType);
    }

    private @NonNull List<@NonNull ICallPath> getMutablechildren() {
        List<@NonNull ICallPath> children = this.mChildren;
        if (children == null) {
            this.mChildren = children = new ArrayList<ICallPath>(1);
        }
        return children;
    }

    private void makeFullName(StringBuilder buffer) {
        if (this.mParent != null) {
            buffer.append(this.mParent.getFullName());
        }
        if (buffer.length() > 0) {
            buffer.append(" | ");
        }
        buffer.append(this.getName());
    }
}

