/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters;

import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class InstructionCounterConstants {
    public static final @NonNull String CALLPATHS_BIN = "callpaths.bin";
    public static final @NonNull String CALLPATHS_FILE_BIN = "callpaths.bin";
    public static final @NonNull String ICOUNTER = "icounter";
    public static final @NonNull String INSTRUCTIONS_BIN = "instructions.bin";
    public static final @NonNull String LINES_BIN = "lines.bin";
    public static final @NonNull String METADATA_XML = "metadata.xml";
    public static final @NonNull String METRICS = "metrics";
    public static final @NonNull String TIMELINE = "timeline";

    public static final @NonNull List<@NonNull MetadataPathAndId<InstructionCounterMetadataXml>> enumerateEvents(@NonNull File reportPath, int sourceId) throws IOException {
        File eventDir;
        File metadataFile;
        @NonNull ArrayList<@NonNull MetadataPathAndId<InstructionCounterMetadataXml>> result = new ArrayList<MetadataPathAndId<InstructionCounterMetadataXml>>();
        int eventId = 0;
        while ((metadataFile = new File(eventDir = InstructionCounterConstants.getEventPath(reportPath, sourceId, eventId), METADATA_XML)).isFile()) {
            @NonNull InstructionCounterMetadataXml metadata = InstructionCounterMetadataXml.load(metadataFile);
            result.add(new MetadataPathAndId<InstructionCounterMetadataXml>(eventDir, eventId, metadata));
            ++eventId;
        }
        return result;
    }

    public static final @NonNull List<@NonNull MetadataPathAndId<InstructionCounterSourceMetadata>> enumerateSources(@NonNull File reportPath) throws IOException {
        File sourceDir;
        File sourceMetadataFile;
        @NonNull ArrayList<@NonNull MetadataPathAndId<InstructionCounterSourceMetadata>> result = new ArrayList<MetadataPathAndId<InstructionCounterSourceMetadata>>();
        int sourceId = 0;
        while ((sourceMetadataFile = new File(sourceDir = InstructionCounterConstants.getSourcePath(reportPath, sourceId), METADATA_XML)).isFile()) {
            @NonNull InstructionCounterSourceMetadata metadata = InstructionCounterSourceMetadata.load((File)sourceMetadataFile);
            result.add(new MetadataPathAndId<InstructionCounterSourceMetadata>(sourceDir, sourceId, metadata));
            ++sourceId;
        }
        return result;
    }

    public static final @NonNull File getDataPointPath(@NonNull File counterPath, int dataPointId) {
        return new File(counterPath, Integer.toString(dataPointId));
    }

    public static final @NonNull File getDataPointPath(@NonNull File reportPath, int sourceId, int eventId, int dataPointId) {
        return new File(InstructionCounterConstants.getEventPath(reportPath, sourceId, eventId), Integer.toString(dataPointId));
    }

    public static final @NonNull File getEventPath(@NonNull File sourcePath, int eventId) {
        return new File(sourcePath, Integer.toString(eventId));
    }

    public static final @NonNull File getEventPath(@NonNull File reportPath, int sourceId, int eventId) {
        return new File(InstructionCounterConstants.getSourcePath(reportPath, sourceId), Integer.toString(eventId));
    }

    public static final @NonNull File getSourcePath(@NonNull File reportPath, int sourceId) {
        return new File(new File(reportPath, ICOUNTER), Integer.toString(sourceId));
    }

    public static final class MetadataPathAndId<T> {
        public final @NonNull File path;
        public final int id;
        public final @NonNull T metadata;

        public MetadataPathAndId(@NonNull File path, int id, @NonNull T metadata) {
            this.path = path;
            this.id = id;
            this.metadata = metadata;
        }
    }
}

