/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IExtractable;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IImagesFile;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SourceFile
implements IExtractable,
Comparable<SourceFile>,
ISourceReference {
    public static final long IGNORE_TIMESTAMP = Long.MIN_VALUE;
    private final @NonNull ArrayList<IFunction> functions = new ArrayList();
    private final @NonNull String name;
    private long timestamp;
    private final int index;
    private final int dirIndex;
    private final int imageIndex;
    private final int lineMapOffset;
    private final int lineMapEntryCount;
    private final @NonNull IImagesFile imagesFile;
    private final @NonNull ISourcefileLineMap sourcefileLineMap;

    public static String getLineColumnDescription(int line, int column) {
        StringBuilder buffer = new StringBuilder();
        if (line > 0) {
            buffer.append(':');
            buffer.append(line);
            if (column > 1) {
                buffer.append(':');
                buffer.append(column);
            }
        }
        return buffer.toString();
    }

    public static String getLineColumnDescription(ISourceReference sourceRef) {
        return SourceFile.getLineColumnDescription(sourceRef.getStartLine(), sourceRef.getStartColumn());
    }

    public SourceFile(@NonNull IImagesFile imagesFile, @NonNull ISourcefileLineMap sourcefileLineMap) {
        this.imagesFile = imagesFile;
        this.sourcefileLineMap = sourcefileLineMap;
        this.name = "<unknown>";
        this.dirIndex = 0;
        this.index = 0;
        this.imageIndex = 0;
        this.lineMapOffset = 0;
        this.lineMapEntryCount = 0;
        this.timestamp = 0L;
    }

    public SourceFile(@NonNull IImagesFile imagesFile, @NonNull ISourcefileLineMap sourcefileLineMap, int index, @NonNull String name, int dirIndex, int imageIndex, int lineMapOffset, int lineMapEntryCount, long timestamp) {
        this.imagesFile = imagesFile;
        this.sourcefileLineMap = sourcefileLineMap;
        this.name = name;
        this.dirIndex = dirIndex;
        this.index = index;
        this.imageIndex = imageIndex;
        this.lineMapOffset = lineMapOffset;
        this.lineMapEntryCount = lineMapEntryCount;
        this.timestamp = timestamp;
    }

    public void add(IFunction function) {
        this.functions.add(function);
    }

    @Override
    public int compareTo(SourceFile other) {
        if (this == other) {
            return 0;
        }
        return this.getFullPath().compareTo(other.getFullPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SourceFile) {
            return this.compareTo((SourceFile)obj) == 0;
        }
        return false;
    }

    public boolean exists() {
        File file = new File(this.getFullPath());
        return file.exists();
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
        for (IFunction function : this.functions) {
            function.extractCallChainLinks(collection);
        }
    }

    @Override
    public void extractDisassemblyLines(BitSet set) {
        for (IFunction function : this.functions) {
            function.extractDisassemblyLines(set);
        }
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        collection.addAll(this.functions);
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        collection.add(this);
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        collection.add(this);
    }

    public int getDirIndex() {
        return this.dirIndex;
    }

    public @NonNull String getFullPath() {
        return FilePath.getFullPath((String)this.imagesFile.getDirectory(this.dirIndex), (String)this.getName());
    }

    public @Nullable IFunction getFunction(int line) {
        return this.sourcefileLineMap.getFunction(this, line);
    }

    public ArrayList<IFunction> getFunctions() {
        return new ArrayList<IFunction>(this.functions);
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getIndexOffset() {
        return this.lineMapOffset;
    }

    public int getIndexCount() {
        return this.lineMapEntryCount;
    }

    @Override
    public SourceFile getSourceFile() {
        return this;
    }

    @Override
    public int getStartColumn() {
        return 0;
    }

    @Override
    public int getStartLine() {
        return 0;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    public boolean isBinary() {
        return this.imageIndex == this.index;
    }

    public boolean isInlined(int line) {
        return this.sourcefileLineMap.isInlined(this, line);
    }

    public void setTimeStamp(long timeStamp) {
        this.timestamp = timeStamp;
    }

    public String toString() {
        return this.getName();
    }
}

