/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IExtractable;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import java.util.BitSet;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleSourceReference
implements ISourceReference,
IExtractable {
    final @NonNull SourceFile mFile;
    final int mLine;
    final int mColumn;

    public SimpleSourceReference(@NonNull SourceFile file, int line) {
        this(file, line, 0);
    }

    public SimpleSourceReference(@NonNull SourceFile file, int line, int column) {
        this.mFile = file;
        this.mLine = line;
        this.mColumn = column;
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
        IFunction function;
        if (this.mLine > 0 && (function = this.mFile.getFunction(this.mLine)) != null) {
            function.extractCallChainLinks(collection);
        }
    }

    @Override
    public void extractDisassemblyLines(final BitSet set) {
        @Nullable IFunction function = this.mFile.getFunction(this.mLine);
        if (function != null) {
            function.forEachInstruction(entry -> entry.accept(new IInstructionsFile.IInstructionsFileEntryVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visit(@NonNull IInstructionsFile.IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visit(@NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visit(@NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
                    if (entry.getSourceFile() == SimpleSourceReference.this.mFile && entry.getLine() == SimpleSourceReference.this.mLine) {
                        set.set(entry.getIndex());
                    }
                    return null;
                }
            }, null));
        }
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        IFunction function;
        if (this.mLine > 0 && (function = this.mFile.getFunction(this.mLine)) != null) {
            collection.add(function);
        }
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        collection.add(this.mFile);
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        collection.add(this);
    }

    @Override
    public SourceFile getSourceFile() {
        return this.mFile;
    }

    @Override
    public int getStartColumn() {
        return this.mColumn;
    }

    @Override
    public int getStartLine() {
        return this.mLine;
    }
}

