/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.report.model.DisassemblerFrontend;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.IRawInstructionsFile;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.ImagesFile;
import com.arm.streamline.report.model.SimpleSourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RawInstructionsFile
implements IRawInstructionsFile {
    protected static boolean UNABLE_TO_DISASSEMBLE = false;
    private final @NonNull IInstructionCounterFunctions functions;
    private final @NonNull ImagesFile imagesFile;
    private final long @NonNull [] mAddresses;
    private final int mCount;
    private final int @NonNull [] mFiles;
    private final int @NonNull [] mFunctionIndexes;
    private final boolean mHas64BitAddresses;
    private final int @NonNull [] mLines;
    private final int @NonNull [] mOpcodes;
    private final @NonNull File mStaticFile;
    private @Nullable DisassemblerFrontend mDisasm;

    private static @NonNull File getStaticFile(File reportDir) {
        return new File(reportDir, "icounter/instructions.bin");
    }

    public RawInstructionsFile(@NonNull File reportDirectory, @NonNull ImagesFile imagesFile, @NonNull IInstructionCounterFunctions functions, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        tracker.setSubTaskTitle(Messages.INSTRUCTIONS);
        this.imagesFile = imagesFile;
        this.functions = functions;
        if (!UNABLE_TO_DISASSEMBLE) {
            DisassemblerFrontend disasm = null;
            try {
                disasm = new DisassemblerFrontend(functions);
            }
            catch (Throwable t) {
                UNABLE_TO_DISASSEMBLE = true;
            }
            this.mDisasm = disasm;
        }
        this.mStaticFile = RawInstructionsFile.getStaticFile(reportDirectory);
        this.mCount = (int)(this.mStaticFile.length() / 20L);
        this.mAddresses = new long[this.mCount];
        this.mOpcodes = new int[this.mCount];
        this.mFiles = new int[this.mCount];
        this.mLines = new int[this.mCount];
        this.mFunctionIndexes = new int[this.mCount];
        if (this.mCount <= 0) {
            this.mHas64BitAddresses = false;
        } else {
            long mask = 0L;
            int lastFunctionIndex = -1;
            Throwable throwable = null;
            Object var9_11 = null;
            try (CountedInputStream countStaticIn = new CountedInputStream(this.mStaticFile);){
                tracker.setProgressProvider((IProgressProvider)countStaticIn);
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (LittleEndianDataInputStream staticIn = new LittleEndianDataInputStream((InputStream)countStaticIn);){
                    int i = 0;
                    while (i < this.mCount) {
                        this.mAddresses[i] = staticIn.readLELong();
                        mask |= this.mAddresses[i];
                        this.mOpcodes[i] = staticIn.readLEInt();
                        this.mFiles[i] = staticIn.readLEInt();
                        this.mLines[i] = staticIn.readLEInt();
                        if ((this.mFiles[i] & 0x1000000) != 0) {
                            lastFunctionIndex = i;
                        }
                        this.mFunctionIndexes[i] = lastFunctionIndex;
                        if (i % 50000 == 0) {
                            tracker.update();
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            this.mHas64BitAddresses = (mask & 0xFFFFFFFF00000000L) != 0L;
        }
    }

    @Override
    public int findFirstFunctionIndexAtOrBefore(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mCount == 0) {
            return -1;
        }
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.mFunctionIndexes[index];
    }

    @Override
    public int findFirstInstructionIndexOnOrAfter(int index) {
        while (index < this.mCount && !this.isInstruction(index)) {
            ++index;
        }
        if (index >= this.mCount) {
            return -1;
        }
        return index;
    }

    @Override
    public void forEachInstructionGetSourceInfo(@NonNull IRawInstructionsFile.IInstructionSourceLineInfoConsumer consumer) {
        int lastSourceFileIndex = -1;
        SourceFile lastSourceFile = null;
        int i = 0;
        while (i < this.mCount) {
            SourceFile sourceFile;
            if (this.isInstruction(i)) {
                int sourceFileIndex = this.getSourceFileIndex(i);
                if (sourceFileIndex != lastSourceFileIndex) {
                    lastSourceFileIndex = sourceFileIndex;
                    lastSourceFile = this.imagesFile.getFiles().get(lastSourceFileIndex);
                }
                sourceFile = lastSourceFile;
            } else {
                sourceFile = null;
            }
            int sourceLine = sourceFile != null ? this.getLine(i) : 0;
            consumer.accept(i, sourceFile, sourceLine);
            ++i;
        }
    }

    @Override
    public long getAddressForIndex(int index) {
        if (index < 0 || index >= this.mCount) {
            if (index == 0) {
                return 0L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.isFunction(index) && ++index >= this.mCount) {
            return 0L;
        }
        if (this.isInstruction(index)) {
            return this.mAddresses[index];
        }
        return 0L;
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public @NonNull IInstructionsFile.IInstructionsFileEntry getEntry(int index) {
        if (index < 0 || index >= this.mCount) {
            if (index == 0) {
                return new InstructionsFileFunctionEntry(0, this.functions.getAnonymous(), false);
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.isFunction(index)) {
            return new InstructionsFileFunctionEntry(index, this.functions.get((int)this.mAddresses[index]), this.isScript(index));
        }
        if (this.isBreak(index)) {
            int functionIndex = this.findFirstFunctionIndexAtOrBefore(index);
            @Nullable IInstructionsFile.IInstructionsFileFunctionEntry function = functionIndex >= 0 ? (IInstructionsFile.IInstructionsFileFunctionEntry)this.getEntry(functionIndex) : null;
            return new InstructionsFileBreakEntry(index, this.mAddresses[index], function);
        }
        if (this.isInstruction(index)) {
            IInstructionsFile.IInstructionsFileInstructionEntry.Type type;
            @Nullable SourceFile sourceFile = this.getSourceFile(index);
            boolean thumb = this.isThumbOpcode(index);
            boolean thumbee = this.isThumbEEOpcode(index);
            boolean thumb16 = this.isOpcode16Bit(index);
            boolean arm64 = this.isObanOpcode(index);
            boolean script = this.isScript(index);
            int functionIndex = this.findFirstFunctionIndexAtOrBefore(index);
            if (functionIndex < 0) {
                throw new AssertionError((Object)"Invalid instructions file (instruction not proceeded by function)");
            }
            @NonNull IInstructionsFile.IInstructionsFileFunctionEntry function = (IInstructionsFile.IInstructionsFileFunctionEntry)this.getEntry(functionIndex);
            if (script != function.isScript()) {
                throw new AssertionError((Object)"Invalid instructions file (mixed script/non-script function/instruction)");
            }
            if (script) {
                if (arm64 || thumb || thumbee || thumb16) {
                    throw new AssertionError((Object)"Invalid instructions file (invalid opcode combination)");
                }
                type = IInstructionsFile.IInstructionsFileInstructionEntry.Type.SCRIPT;
            } else if (arm64) {
                if (thumb || thumbee || thumb16) {
                    throw new AssertionError((Object)"Invalid instructions file (invalid opcode combination)");
                }
                type = IInstructionsFile.IInstructionsFileInstructionEntry.Type.A64;
            } else {
                type = thumb || thumbee || thumb16 ? (thumbee ? (thumb16 ? IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32EE_16BIT : IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32EE_32BIT) : (thumb16 ? IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32_16BIT : IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32_32BIT)) : IInstructionsFile.IInstructionsFileInstructionEntry.Type.A32;
            }
            return new InstructionsFileInstructionEntry(function, index, type, this.mAddresses[index], this.mOpcodes[index], sourceFile, this.getLine(index), this.isInlined(index), this.mDisasm);
        }
        throw new AssertionError((Object)"Invalid instructions file (unknown type)");
    }

    @Override
    public int @NonNull [] getIndexesForAddress(long address) {
        TIntArrayList list = new TIntArrayList();
        int i = 0;
        while (i < this.mAddresses.length) {
            if (this.isInstruction(i) && this.mAddresses[i] == address) {
                list.add(i);
            }
            ++i;
        }
        return (int[])NullChecking.neverNull((Object)list.toArray());
    }

    @Override
    public boolean has64BitAddresses() {
        return this.mHas64BitAddresses;
    }

    @Override
    public void close() throws Exception {
        DisassemblerFrontend disasm = this.mDisasm;
        if (disasm != null) {
            disasm.close();
        }
    }

    private int getLine(int index) {
        return this.mLines[index] & 0xFFFFFF;
    }

    private @Nullable SourceFile getSourceFile(int index) {
        return this.imagesFile.getFiles().get(this.getSourceFileIndex(index));
    }

    private int getSourceFileIndex(int index) {
        return this.mFiles[index] & 0xFFFFFF;
    }

    private boolean isBreak(int index) {
        return (this.mFiles[index] & 0x2000000) != 0;
    }

    private boolean isFunction(int index) {
        return (this.mFiles[index] & 0x1000000) != 0;
    }

    private boolean isInlined(int index) {
        return (this.mFiles[index] & 0x20000000) != 0;
    }

    private boolean isInstruction(int index) {
        return (this.mFiles[index] & 0x3000000) == 0;
    }

    private boolean isObanOpcode(int index) {
        return (this.mFiles[index] & 0x40000000) != 0;
    }

    private boolean isOpcode16Bit(int index) {
        return (this.mFiles[index] & 0x10000000) != 0;
    }

    private boolean isScript(int index) {
        return (this.mFiles[index] & Integer.MIN_VALUE) != 0;
    }

    private boolean isThumbEEOpcode(int index) {
        return (this.mFiles[index] & 0x8000000) != 0;
    }

    private boolean isThumbOpcode(int index) {
        return (this.mFiles[index] & 0x4000000) != 0;
    }

    private static final class InstructionsFileBreakEntry
    implements IInstructionsFile.IInstructionsFileBreakEntry {
        private final long bytesInBreak;
        private final @Nullable IInstructionsFile.IInstructionsFileFunctionEntry function;
        private final int index;

        public InstructionsFileBreakEntry(int index, long bytesInBreak, @Nullable IInstructionsFile.IInstructionsFileFunctionEntry function) {
            this.index = index;
            this.bytesInBreak = bytesInBreak;
            this.function = function;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionsFile.IInstructionsFileEntryVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public long getBytesInBreak() {
            return this.bytesInBreak;
        }

        @Override
        public @Nullable IInstructionsFile.IInstructionsFileFunctionEntry getFunction() {
            return this.function;
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    private static final class InstructionsFileFunctionEntry
    implements IInstructionsFile.IInstructionsFileFunctionEntry {
        private final @NonNull IFunction function;
        private final int index;
        private final boolean script;

        public InstructionsFileFunctionEntry(int index, @NonNull IFunction function, boolean script) {
            this.index = index;
            this.function = function;
            this.script = script;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionsFile.IInstructionsFileEntryVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public @NonNull IFunction getFunction() {
            return this.function;
        }

        @Override
        public @NonNull String getFunctionAddressDescription(long address) {
            @NonNull StringBuilder builder = new StringBuilder();
            builder.append(this.function.getName());
            long delta = address - this.function.getAddress();
            if (delta != 0L) {
                builder.append(" + 0x");
                builder.append(Long.toHexString(delta));
            }
            return builder.toString();
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isScript() {
            return this.script;
        }
    }

    private static final class InstructionsFileInstructionEntry
    implements IInstructionsFile.IInstructionsFileInstructionEntry {
        private final long address;
        private final @NonNull IInstructionsFile.IInstructionsFileFunctionEntry function;
        private final int index;
        private final boolean inlined;
        private final int opcode;
        private final @Nullable SourceFile sourceFile;
        private final int sourceLine;
        private final @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type type;
        private final @Nullable DisassemblerFrontend disasm;

        public InstructionsFileInstructionEntry(@NonNull IInstructionsFile.IInstructionsFileFunctionEntry function, int index, @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type type, long address, int opcode, @Nullable SourceFile sourceFile, int sourceLine, boolean inlined, @Nullable DisassemblerFrontend disasm) {
            this.function = function;
            this.index = index;
            this.type = type;
            this.address = address;
            this.opcode = opcode;
            this.sourceFile = sourceFile;
            this.sourceLine = sourceLine;
            this.inlined = inlined;
            this.disasm = disasm;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionsFile.IInstructionsFileEntryVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        @Override
        public @Nullable ISourceReference createSourceReference() {
            @Nullable SourceFile sourceFile = this.sourceFile;
            return sourceFile != null ? new SimpleSourceReference(sourceFile, this.sourceLine) : null;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public @NonNull String getDisassembly() {
            StringBuilder buffer;
            block10: {
                buffer = new StringBuilder();
                try {
                    DisassemblerFrontend disasm = this.disasm;
                    if (disasm == null || UNABLE_TO_DISASSEMBLE) break block10;
                    try {
                        switch (this.type) {
                            case A32: {
                                disasm.disassembleA32(this.address, this.opcode, buffer, this.function.getFunction().getSection());
                                break;
                            }
                            case A64: {
                                disasm.disassembleA64(this.address, this.opcode, buffer, this.function.getFunction().getSection());
                                break;
                            }
                            case SCRIPT: {
                                break;
                            }
                            case T32_16BIT: 
                            case T32_32BIT: 
                            case T32EE_16BIT: 
                            case T32EE_32BIT: {
                                boolean thumb16 = this.type == IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32_16BIT || this.type == IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32EE_16BIT;
                                boolean thumbee = this.type == IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32EE_16BIT || this.type == IInstructionsFile.IInstructionsFileInstructionEntry.Type.T32EE_32BIT;
                                short op1 = (short)(this.opcode & 0xFFFF);
                                short op2 = (short)(thumb16 ? 0 : this.opcode >> 16 & 0xFFFF);
                                disasm.disassembleT32(this.address, op1, op2, thumbee, buffer, this.function.getFunction().getSection());
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        UNABLE_TO_DISASSEMBLE = true;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    CommonPlugin.error((Throwable)throwable);
                }
            }
            return buffer.toString();
        }

        @Override
        public @NonNull IInstructionsFile.IInstructionsFileFunctionEntry getFunction() {
            return this.function;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getLine() {
            return this.sourceLine;
        }

        @Override
        public int getOpcode() {
            return this.opcode;
        }

        @Override
        public @Nullable SourceFile getSourceFile() {
            return this.sourceFile;
        }

        @Override
        public @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type getType() {
            return this.type;
        }

        @Override
        public boolean isInlined() {
            return this.inlined;
        }
    }
}

