/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.jni.common.MMappedFile;
import com.arm.streamline.report.model.IndexData;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class MmappedIndexData
implements IndexData {
    private MMappedFile mappedBuffer;
    private long filePointer;
    private final long size;

    public MmappedIndexData(@NonNull File indexFile) throws IOException {
        IOException lastException = null;
        int i = 0;
        while (i < 5 && this.mappedBuffer == null) {
            try {
                this.mappedBuffer = new MMappedFile(indexFile);
            }
            catch (IOException ex) {
                lastException = ex;
            }
            ++i;
        }
        if (this.mappedBuffer == null) {
            throw new IOException("Could not map index file", lastException);
        }
        this.size = this.mappedBuffer.size();
    }

    @Override
    public void close() throws IOException {
        this.mappedBuffer.close();
    }

    @Override
    public long readNext() throws IOException {
        try {
            long l = this.mappedBuffer.read64(this.filePointer, true);
            return l;
        }
        finally {
            this.filePointer += 8L;
        }
    }

    @Override
    public void seek(long position) {
        this.filePointer = position;
    }

    @Override
    public boolean hasRemaining() {
        return this.size - this.filePointer >= 16L;
    }
}

