/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.FunctionNameComparator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import java.util.BitSet;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FunctionImpl
implements IFunction {
    private static final String ANONYMOUS_PREFIX = "<";
    private static final String C_PLUS_PLUS_STDLIB_PREFIX = "std::";
    private static final String C_SYSTEM_PREFIX = "_";
    private static final String GENERATED_CODE_PREFIX = "$";
    private static final String PLT_PREFIX = ".";
    private static final String PROCESS_PREFIX = "[";
    private static final String THREAD_PREFIX = "{";
    private final long address;
    private final int column;
    private final int firstInstructionIndex;
    private final int firstSourceLine;
    private final int id;
    private final @NonNull SourceFile imageFile;
    private final @NonNull IInstructionsFile instructionsFile;
    private final int lastInstructionIndex;
    private final int lastSourceLine;
    private final int line;
    private final @NonNull String name;
    private final boolean script;
    private final long section;
    private final @Nullable String shortName;
    private final int size;
    private final @NonNull SourceFile sourceFile;
    private final int stack;
    private final boolean unknown;
    private final @Nullable String unmangledName;

    public FunctionImpl(@NonNull IInstructionsFile instructionsFile, int id, boolean script, boolean unknown, @NonNull String name, @Nullable String shortName, @Nullable String unmangledName, int size, int firstInstructionIndex, int lastInstructionIndex, int firstSourceLine, int lastSourceLine, int line, int column, int stack, @NonNull SourceFile sourceFile, long section, @NonNull SourceFile imageFile, long address) {
        this.instructionsFile = instructionsFile;
        this.id = id;
        this.script = script;
        this.unknown = unknown;
        this.name = name;
        this.shortName = shortName;
        this.unmangledName = unmangledName;
        this.size = size;
        this.firstInstructionIndex = firstInstructionIndex;
        this.lastInstructionIndex = lastInstructionIndex;
        this.firstSourceLine = firstSourceLine;
        this.lastSourceLine = lastSourceLine;
        this.line = line;
        this.column = column;
        this.stack = stack;
        this.sourceFile = sourceFile;
        this.section = section;
        this.imageFile = imageFile;
        this.address = address;
    }

    @Override
    public int compareTo(IFunction other) {
        int result = FunctionNameComparator.COMPARATOR.compare(this.getName(), other.getName());
        if (result == 0) {
            result = this.sourceFile.compareTo(other.getSourceFile());
        }
        return result;
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
    }

    @Override
    public void extractDisassemblyLines(BitSet set) {
        set.set(this.firstInstructionIndex + 1, this.lastInstructionIndex + 1);
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        collection.add(this);
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        collection.add(this.sourceFile);
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        collection.add(this);
    }

    @Override
    public void forEachInstruction(@NonNull Consumer<@NonNull IInstructionsFile.IInstructionsFileEntry> consumer) {
        int i = this.firstInstructionIndex + 1;
        while (i <= this.lastInstructionIndex) {
            @NonNull IInstructionsFile.IInstructionsFileEntry entry = this.instructionsFile.getEntry(i);
            consumer.accept(entry);
            ++i;
        }
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public int getFirstInstructionIndex() {
        return this.firstInstructionIndex;
    }

    @Override
    public int getFirstSourceLine() {
        return this.firstSourceLine;
    }

    @Override
    public @NonNull SourceFile getImageFile() {
        return this.imageFile;
    }

    @Override
    public int getIndex() {
        return this.id;
    }

    @Override
    public int getLastInstructionIndex() {
        return this.lastInstructionIndex;
    }

    @Override
    public int getLastSourceLine() {
        return this.lastSourceLine;
    }

    @Override
    public String getMangledName() {
        return this.name;
    }

    @Override
    public @NonNull String getName() {
        if (this.shortName != null) {
            return this.shortName;
        }
        if (this.unmangledName != null) {
            return this.unmangledName;
        }
        return this.name;
    }

    @Override
    public long getSection() {
        return this.section;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public int getStackSize() {
        return this.stack;
    }

    @Override
    public int getStartColumn() {
        return this.column;
    }

    @Override
    public int getStartLine() {
        return this.line;
    }

    @Override
    public String getUnmangledName() {
        return this.unmangledName;
    }

    @Override
    public boolean hasUnknownStack() {
        return this.unknown || this.stack < 0;
    }

    @Override
    public boolean isScript() {
        return this.script;
    }

    @Override
    public boolean isSystemFunction() {
        if (this.isUnknown()) {
            return true;
        }
        String name = this.getName();
        if (name.startsWith(C_PLUS_PLUS_STDLIB_PREFIX)) {
            return true;
        }
        if (name.startsWith(C_SYSTEM_PREFIX)) {
            return true;
        }
        if (name.startsWith(PLT_PREFIX)) {
            return true;
        }
        if (name.startsWith(PROCESS_PREFIX)) {
            return true;
        }
        if (name.startsWith(THREAD_PREFIX)) {
            return true;
        }
        if (name.startsWith(ANONYMOUS_PREFIX)) {
            return true;
        }
        return name.startsWith(GENERATED_CODE_PREFIX);
    }

    @Override
    public boolean isUnknown() {
        return this.unknown || this.name.startsWith("<unknown code in ");
    }

    public String toString() {
        return this.getName();
    }
}

