/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.debug.icodec.ct.CompilerTools;
import com.arm.debug.icodec.disasm.Disassembler;
import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.DisasslibCallbackBase;
import com.arm.debug.icodec.swig.InstructionType;
import com.arm.rosetta.IRosettaCallback;
import com.arm.rosetta.RosettaDisassembler;
import com.arm.rosetta.RosettaManager;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.utils.function.Throwing;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DisassemblerFrontend
implements AutoCloseable {
    private final @NonNull IInstructionCounterFunctions functions;
    private @Nullable RosettaDisassembler rosettaDisasm;
    private final @NonNull Disassembler icodecDisasm;
    private final @NonNull Architecture icodecArch32;
    private final @NonNull Architecture icodecArch64;

    private static void genericFormatter(long address, @NonNull IFunction function, @NonNull StringBuilder buffer) {
        long functionAddress = function.getAddress();
        if (address == functionAddress) {
            buffer.append(function.getName());
            buffer.append(" ; ");
            buffer.append(NumberUtils.formatAddress((long)address));
        } else {
            buffer.append(NumberUtils.formatAddress((long)address));
            buffer.append(" ; ");
            buffer.append(function.getName());
            buffer.append(" + ");
            buffer.append("0x");
            buffer.append(Long.toHexString(address - functionAddress).toUpperCase());
        }
    }

    public DisassemblerFrontend(@NonNull IInstructionCounterFunctions functions) {
        this.functions = functions;
        try {
            this.rosettaDisasm = RosettaManager.makeDisassembler((RosettaDisassembler.ArchProfile)RosettaDisassembler.ArchProfile.PROFILE_64A, (int)8, (int)0);
        }
        catch (Throwable t) {
            StdLog.info((Plugin)CommonPlugin.getInstance(), (String)"Rosetta disassembler could not be initialised, falling back to icodec");
            this.rosettaDisasm = null;
        }
        try {
            this.icodecDisasm = CompilerTools.disassembler();
        }
        catch (Throwable t) {
            StdLog.info((Plugin)CommonPlugin.getInstance(), (String)"icodec disassembler could not be initialised, no disassembly will be available");
            throw t;
        }
        this.icodecArch32 = new Architecture(Architecture.CoreVersion.core_unsafe, Architecture.VFPNEONVersion.vfpneon_unsafe);
        this.icodecArch64 = new Architecture(Architecture.CoreVersion.core_v8A_64, Architecture.VFPNEONVersion.vfpneon_v8A_fp_neon);
    }

    public void disassembleA32(long address, int opcode, @NonNull StringBuilder buffer, long section) {
        Throwable throwable = null;
        Object var8_7 = null;
        try (IcodecCallBack callback = new IcodecCallBack(this.functions, section);){
            this.icodecDisasm.disassembleARM(address, opcode, (DisasslibCallbackBase)callback, buffer, this.icodecArch32);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void disassembleA64(long address, int opcode, @NonNull StringBuilder buffer, long section) {
        if (this.rosettaDisasm != null) {
            @NonNull RosettaCallBack callback = new RosettaCallBack(this.functions, section);
            this.rosettaDisasm.disassembleA64(address, (long)opcode, (IRosettaCallback)callback, buffer);
        } else {
            Throwable throwable = null;
            Object var8_8 = null;
            try (IcodecCallBack callback = new IcodecCallBack(this.functions, section);){
                this.icodecDisasm.disassembleAArch64(address, opcode, (DisasslibCallbackBase)callback, buffer, this.icodecArch64);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void disassembleT32(long address, short opcode1, short opcode2, boolean thumbEE, @NonNull StringBuilder buffer, long section) {
        Throwable throwable = null;
        Object var10_9 = null;
        try (IcodecCallBack callback = new IcodecCallBack(this.functions, section);){
            this.icodecDisasm.disassembleThumb(address, opcode1, opcode2, thumbEE, (DisasslibCallbackBase)callback, buffer, this.icodecArch32);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws Exception {
        Throwing.closeAll((AutoCloseable[])new AutoCloseable[]{this.icodecArch32, this.icodecArch64, this.rosettaDisasm});
    }

    private static class IcodecCallBack
    extends DisasslibCallbackBase {
        private final @NonNull IInstructionCounterFunctions functionsFile;
        private final long section;

        public IcodecCallBack(@NonNull IInstructionCounterFunctions functionsFile, long section) {
            this.functionsFile = functionsFile;
            this.section = section;
        }

        public String callback(InstructionType type, int offset, long address, int width) {
            IFunction function;
            StringBuilder buffer = new StringBuilder();
            if (type == InstructionType.D_BORBL && (function = this.functionsFile.getFunctionInSection(this.section, address)) != null) {
                DisassemblerFrontend.genericFormatter(address, function, buffer);
            }
            return buffer.toString();
        }
    }

    private static class RosettaCallBack
    implements IRosettaCallback {
        private final @NonNull IInstructionCounterFunctions functionsFile;
        private final long section;

        public RosettaCallBack(@NonNull IInstructionCounterFunctions functionsFile, long section) {
            this.functionsFile = functionsFile;
            this.section = section;
        }

        public String resolveBranch(long address) {
            IFunction function = this.functionsFile.getFunctionInSection(this.section, address);
            if (function != null) {
                StringBuilder buffer = new StringBuilder();
                DisassemblerFrontend.genericFormatter(address, function, buffer);
                return buffer.toString();
            }
            return null;
        }
    }
}

