/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class CallPathFunction
implements ICallPathFunction {
    private final long @NonNull [] @NonNull [] cumulativeSelfValues;
    private final @NonNull IFunction function;
    private boolean hasValues;
    private final long @NonNull [] maximumSelfValues;
    private final @NonNull List<@NonNull ICallPath> mCallPaths = new ArrayList<ICallPath>();
    private final int @NonNull [] numberOfDataPointIndexesByEventId;
    private final @NonNull ICallPath rootCallPath;

    public CallPathFunction(@NonNull ICallPath rootCallPath, @NonNull IFunction function, int @NonNull [] numberOfDataPointIndexesByEventId, long @NonNull [] maximumSelfValues) {
        if (maximumSelfValues.length != numberOfDataPointIndexesByEventId.length) {
            throw new IllegalArgumentException();
        }
        this.rootCallPath = rootCallPath;
        this.function = function;
        this.numberOfDataPointIndexesByEventId = numberOfDataPointIndexesByEventId;
        long @NonNull [] @NonNull [] cumulativeSelfValues = (long[][])ArrayUtils.create(n -> new long[n][], (int)numberOfDataPointIndexesByEventId.length, i -> new long[numberOfDataPointIndexesByEventId[i]]);
        this.cumulativeSelfValues = cumulativeSelfValues;
        this.maximumSelfValues = maximumSelfValues;
    }

    public void addTimeFrom(@NonNull ICallPath path) {
        this.mCallPaths.add(path);
        int eventId = 0;
        while (eventId < this.numberOfDataPointIndexesByEventId.length) {
            int numDataPointIndexes = this.numberOfDataPointIndexesByEventId[eventId];
            int dataPointIndex = 0;
            while (dataPointIndex < numDataPointIndexes) {
                long[] lArray = this.cumulativeSelfValues[eventId];
                int n = dataPointIndex;
                lArray[n] = lArray[n] + path.getCounters().getSelfCounterValue(eventId, dataPointIndex);
                this.maximumSelfValues[eventId] = Math.max(this.maximumSelfValues[eventId], this.cumulativeSelfValues[eventId][dataPointIndex]);
                this.hasValues |= this.cumulativeSelfValues[eventId][dataPointIndex] != 0L;
                ++dataPointIndex;
            }
            ++eventId;
        }
    }

    @Override
    public void extractCallChainLinks(Collection<ICallPath> collection) {
        collection.addAll(this.mCallPaths);
    }

    @Override
    public void extractDisassemblyLines(BitSet set) {
        this.function.extractDisassemblyLines(set);
    }

    @Override
    public void extractFunctions(Collection<IFunction> collection) {
        collection.add(this.function);
    }

    @Override
    public void extractSourceFiles(Collection<SourceFile> collection) {
        this.function.extractSourceFiles(collection);
    }

    @Override
    public void extractSourceReferences(Collection<ISourceReference> collection) {
        this.function.extractSourceReferences(collection);
    }

    @Override
    public @NonNull List<@NonNull ICallPath> getCallPaths() {
        return Collections.unmodifiableList(this.mCallPaths);
    }

    @Override
    public long getCallPathTotalCounterValue(int eventId, int dataPointIndex) {
        return this.rootCallPath.getCounters().getTotalCounterValue(eventId, dataPointIndex);
    }

    @Override
    public long getCounterValue(int eventId, int dataPointIndex) {
        return this.cumulativeSelfValues[eventId][dataPointIndex];
    }

    @Override
    public IFunction getFunction() {
        return this.function;
    }

    @Override
    public int getInstanceCount() {
        return this.mCallPaths.size();
    }

    @Override
    public long getMaxValue(int eventId) {
        return this.maximumSelfValues[eventId];
    }

    @Override
    public @NonNull String getName() {
        return this.function.getName();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.function.getSourceFile();
    }

    @Override
    public boolean hasAnyValues() {
        return this.hasValues;
    }

    @Override
    public boolean isUnknown() {
        return this.function.isUnknown();
    }
}

