/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding.wizard;

import com.arm.databinding.wizard.BindableWizardDialog;
import com.arm.databinding.wizard.BindableWizardStep;
import com.arm.databinding.wizard.IBindableWizardPage;
import com.arm.databinding.wizard.IBindableWizardStep;
import com.arm.utils.NullChecking;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractBindableWizardPage
extends WizardPage
implements IBindableWizardPage {
    protected boolean initialMessageSet = false;
    protected @Nullable String initialPageMessageString = null;
    protected final @NonNull IBindableWizardStep step;

    public static void updateCancelAndBackButtons(IBindableWizardStep step, AbstractBindableWizardPage page) {
        IWizardContainer wizard = page.getWizard().getContainer();
        if (wizard instanceof BindableWizardDialog) {
            BindableWizardDialog wDialog = (BindableWizardDialog)wizard;
            wDialog.setCancelButtonEnabled((Boolean)step.canCancel().getValue());
        }
    }

    public static void updateWizardButtons(@NonNull AbstractBindableWizardPage page) {
        IWizardContainer dlg;
        @Nullable IWizard wizard = page.getWizard();
        if (wizard != null && (dlg = wizard.getContainer()) != null) {
            dlg.updateButtons();
        }
    }

    protected AbstractBindableWizardPage(String pageName, @NonNull IBindableWizardStep step_) {
        super(pageName);
        this.step = NullChecking.nullable((Object)step_) != null ? step_ : new BindableWizardStep();
        final @NonNull AbstractBindableWizardPage page = this;
        this.step.canMoveToNextStep().addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

            public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                AbstractBindableWizardPage.updateWizardButtons(page);
            }
        });
        this.step.getValidationStatus().addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

            public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                AbstractBindableWizardPage.updateWizardButtons(page);
                @NonNull IStatus status = (IStatus)NullChecking.neverNull((Object)((IStatus)event.getObservableValue().getValue()));
                switch (status.getSeverity()) {
                    case 4: 
                    case 8: {
                        AbstractBindableWizardPage.this.setMessage(status.getMessage(), 3);
                        break;
                    }
                    case 2: {
                        AbstractBindableWizardPage.this.setMessage(status.getMessage(), 2);
                        break;
                    }
                    case 0: {
                        AbstractBindableWizardPage.this.setMessage(AbstractBindableWizardPage.this.initialPageMessageString);
                        break;
                    }
                    default: {
                        AbstractBindableWizardPage.this.setMessage(status.getMessage(), 0);
                    }
                }
            }
        });
        this.step.canFinish().addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

            public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                AbstractBindableWizardPage.updateWizardButtons(page);
            }
        });
        this.step.canCancel().addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

            public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                AbstractBindableWizardPage.updateCancelAndBackButtons(AbstractBindableWizardPage.this.step, AbstractBindableWizardPage.this);
            }
        });
    }

    public boolean canCancel() {
        return (Boolean)this.step.canCancel().getValue();
    }

    public boolean canFinish() {
        return (Boolean)this.step.canFinish().getValue();
    }

    public boolean canFlipToNextPage() {
        return (Boolean)this.step.canMoveToNextStep().getValue() != false && ((IStatus)this.step.getValidationStatus().getValue()).isOK();
    }

    public boolean canFlipToPreviousPage() {
        return (Boolean)this.step.canMoveToPreviousStep().getValue();
    }

    public void dispose() {
        this.step.beforeDispose();
        super.dispose();
    }

    public IWizardPage getPreviousPage() {
        if (!this.canFlipToPreviousPage()) {
            return null;
        }
        return super.getPreviousPage();
    }

    @Override
    public @NonNull IBindableWizardStep getStep() {
        return this.step;
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (newType == 0 && !this.initialMessageSet) {
            this.initialPageMessageString = newMessage;
        }
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        AbstractBindableWizardPage.updateCancelAndBackButtons(this.step, this);
    }

    protected void performNext() {
        IWizard wizard = this.getWizard();
        IWizardContainer cont = wizard.getContainer();
        if (cont instanceof BindableWizardDialog) {
            BindableWizardDialog dlg = (BindableWizardDialog)cont;
            dlg.nextPressed();
        }
    }
}

