/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding;

import java.util.function.Function;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.jdt.annotation.NonNull;

public abstract class PropertyOnObservable<S, T>
extends ValueProperty<S, T> {
    private final @NonNull IConverter<T, T> modelToTargetConverter;
    private final @NonNull IConverter<T, T> targetToModelConverter;
    private final @NonNull Class<T> valueClass;

    public static <S, T> @NonNull PropertyOnObservable<S, T> create(@NonNull Class<T> valueClass, final @NonNull Function<@NonNull S, @NonNull IObservableValue<T>> functor) {
        return new PropertyOnObservable<S, T>(valueClass){

            @Override
            protected @NonNull IObservableValue<T> getObservable(@NonNull S source) {
                return (IObservableValue)functor.apply(source);
            }
        };
    }

    public PropertyOnObservable(@NonNull Class<T> valueClass) {
        this(valueClass, (IConverter<T, T>)new IdentityConverter(valueClass), (IConverter<T, T>)new IdentityConverter(valueClass));
    }

    public PropertyOnObservable(@NonNull Class<T> valueClass, @NonNull IConverter<T, T> modelToTargetConverter, @NonNull IConverter<T, T> targetToModelConverter) {
        this.valueClass = valueClass;
        this.modelToTargetConverter = modelToTargetConverter;
        this.targetToModelConverter = targetToModelConverter;
    }

    public Object getValueType() {
        return this.valueClass;
    }

    public @NonNull IObservableValue<T> observe(Realm realm, final S source) {
        assert (source != null);
        return new AbstractObservableValue<T>(){

            public synchronized void addChangeListener(IChangeListener listener) {
                PropertyOnObservable.this.getObservable(source).addChangeListener(listener);
            }

            public synchronized void addValueChangeListener(IValueChangeListener<? super T> listener) {
                PropertyOnObservable.this.getObservable(source).addValueChangeListener(listener);
            }

            public Object getValueType() {
                return PropertyOnObservable.this.valueClass;
            }

            public synchronized void removeChangeListener(IChangeListener listener) {
                PropertyOnObservable.this.getObservable(source).removeChangeListener(listener);
            }

            public synchronized void removeValueChangeListener(IValueChangeListener<? super T> listener) {
                PropertyOnObservable.this.getObservable(source).removeValueChangeListener(listener);
            }

            protected T doGetValue() {
                return PropertyOnObservable.this.modelToTargetConverter.convert(PropertyOnObservable.this.getObservable(source).getValue());
            }

            protected void doSetValue(T value) {
                Object modelValue = PropertyOnObservable.this.targetToModelConverter.convert(value);
                PropertyOnObservable.this.getObservable(source).setValue(modelValue);
            }
        };
    }

    protected abstract @NonNull IObservableValue<T> getObservable(@NonNull S var1);
}

