/*
 * Decompiled with CFR 0.152.
 */
package com.arm.databinding;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ObservableLastSelectionFromListMapValue<K, V>
extends AbstractObservableValue<V> {
    private @Nullable V currentSelectedValue;
    private final @NonNull IObservableValue<@Nullable K> keyProperty;
    private final @NonNull IValueChangeListener<@Nullable K> keyPropertyListener;
    private final @NonNull Map<@NonNull K, @NonNull V> lastSelectedValueByKey = new HashMap();
    private final @NonNull IObservableList<@NonNull V> valuesProperty;
    private final @NonNull IListChangeListener<@NonNull V> valuesPropertyListener;

    public ObservableLastSelectionFromListMapValue(@NonNull IObservableValue<@Nullable K> keyProperty, @NonNull IObservableList<@NonNull V> valuesProperty) {
        this.keyProperty = keyProperty;
        this.keyPropertyListener = event -> this.handleKeyChange(keyProperty.getValue());
        this.keyProperty.addValueChangeListener(this.keyPropertyListener);
        this.valuesProperty = valuesProperty;
        this.valuesPropertyListener = event -> this.handleKeyChange(keyProperty.getValue());
        this.valuesProperty.addListChangeListener(this.valuesPropertyListener);
        this.handleKeyChange(keyProperty.getValue());
    }

    public synchronized void dispose() {
        this.keyProperty.removeValueChangeListener(this.keyPropertyListener);
        this.valuesProperty.removeListChangeListener(this.valuesPropertyListener);
        super.dispose();
    }

    public Object getValueType() {
        return this.valuesProperty.getElementType();
    }

    public @NonNull IObservableList<@NonNull V> propertyCurrentValues() {
        return this.valuesProperty;
    }

    protected @Nullable V doGetValue() {
        return this.currentSelectedValue;
    }

    protected void doSetValue(@Nullable V value) {
        final @Nullable V oldValue = this.currentSelectedValue;
        this.currentSelectedValue = value;
        if (value != null) {
            @Nullable Object key = this.keyProperty.getValue();
            if (key != null) {
                this.lastSelectedValueByKey.put(key, value);
            } else assert (false);
        }
        if (this.hasListeners()) {
            this.fireValueChange(new ValueDiff<V>(){

                public @Nullable V getOldValue() {
                    return oldValue;
                }

                public @Nullable V getNewValue() {
                    return ObservableLastSelectionFromListMapValue.this.getValue();
                }
            });
        }
    }

    private void handleKeyChange(@Nullable K newValue) {
        if (newValue == null) {
            this.setValue(null);
        } else {
            @Nullable V newSelectedValue = this.lastSelectedValueByKey.get(newValue);
            if (newSelectedValue != null) {
                if (!this.valuesProperty.contains(newSelectedValue)) {
                    return;
                }
                this.setValue(newSelectedValue);
            } else if (!this.valuesProperty.isEmpty()) {
                @NonNull Object firstAvailableValue = this.valuesProperty.get(0);
                this.setValue(firstAvailableValue);
            } else {
                this.setValue(null);
            }
        }
    }
}

