/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.scheduler;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.utils.ArrayUtils;
import gnu.trove.set.TIntSet;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnalysisActivityActiveCounterAdapter
implements IAnalysisHardwareCounterReader {
    private final @NonNull IAnalysisActivityReader<ProcessingElementReference> activityReader;
    private final @NonNull PerChannelState @NonNull [] perChannelState;
    private final long stopTime;
    private long sequenceCounter;

    public AnalysisActivityActiveCounterAdapter(long stopTime, @NonNull TIntSet idleThreadUIDs, @NonNull IAnalysisActivityReader<ProcessingElementReference> activityReader) {
        this.activityReader = activityReader;
        this.stopTime = stopTime;
        this.perChannelState = (PerChannelState[])ArrayUtils.createNonNull(PerChannelState[]::new, (int)activityReader.getChannels().size(), i -> new PerChannelState(i, idleThreadUIDs));
    }

    @Override
    public void close() throws IOException {
        this.activityReader.close();
    }

    @Override
    public int getChannelCount() {
        return this.perChannelState.length;
    }

    @Override
    public @Nullable IAnalysisHardwareCounterReader.Value read() throws IOException {
        IAnalysisActivityReader.IValue nextEvent = (IAnalysisActivityReader.IValue)this.activityReader.read();
        if (nextEvent != null) {
            long timestamp = nextEvent.getTimestamp();
            int channelIndex = nextEvent.getChannelIndex();
            PerChannelState state = this.perChannelState[channelIndex];
            assert (timestamp <= this.stopTime);
            IAnalysisHardwareCounterReader.Value result = state.value(this.sequenceCounter++, timestamp);
            nextEvent.accept(state.visitor);
            return result;
        }
        int i = 0;
        while (i < this.perChannelState.length) {
            PerChannelState state = this.perChannelState[i];
            if (!state.sentLastValue) {
                state.sentLastValue = true;
                return state.value(this.sequenceCounter++, this.stopTime);
            }
            ++i;
        }
        return null;
    }

    private static class PerChannelState {
        protected @Nullable Integer activeUtid;
        protected final int channelIndex;
        protected final @NonNull TIntSet idleThreadUIDs;
        protected long lastTimestamp;
        protected boolean sentLastValue;
        protected final @NonNull IAnalysisActivityReader.IValueVisitor<ProcessingElementReference> visitor = new IAnalysisActivityReader.IValueVisitor<ProcessingElementReference>(){

            @Override
            public boolean free(long timestamp, int utid) throws IOException {
                return false;
            }

            @Override
            public boolean stop(@NonNull ProcessingElementReference channel, long timestamp, int state) throws IOException {
                activeUtid = null;
                return false;
            }

            @Override
            public boolean swtch(@NonNull ProcessingElementReference channel, long timestamp, @Nullable Integer utid, int activity, int state) throws IOException {
                activeUtid = utid != null && !idleThreadUIDs.contains(utid.intValue()) ? utid : null;
                return false;
            }
        };

        public PerChannelState(int channelIndex, @NonNull TIntSet idleThreadUIDs) {
            this.channelIndex = channelIndex;
            this.idleThreadUIDs = idleThreadUIDs;
        }

        private @NonNull IAnalysisHardwareCounterReader.Value value(long sequenceNo, long timestamp) {
            long duration = timestamp - this.lastTimestamp;
            long value = this.activeUtid != null ? duration : 0L;
            IAnalysisHardwareCounterReader.Value result = new IAnalysisHardwareCounterReader.Value(this.channelIndex, this.lastTimestamp, sequenceNo, duration, this.activeUtid, value);
            this.lastTimestamp = timestamp;
            return result;
        }
    }
}

