/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.binning;

import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class PerThreadPersistantBinningThreadCounterDataPointConsumer
implements IAnalysisBinningThreadCounterDataPointConsumer {
    private final @NonNull TIntObjectMap<PerThreadState> @NonNull [] channelData;
    private final boolean @NonNull [] channelEnded;
    private final long @NonNull [] channelEndTimes;
    private final @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer;
    private int lastExitThreadIndex;
    private final @NonNull UniqueThread @NonNull [] uniqueThreadsByExitTime;
    private final boolean @NonNull [] wroteTerminalZero;

    public PerThreadPersistantBinningThreadCounterDataPointConsumer(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, int channelCount, long @NonNull [] channelEndTimes, @NonNull UniqueThread @NonNull [] uniqueThreadsByExitTime) {
        if (channelCount != channelEndTimes.length) {
            throw new IllegalArgumentException();
        }
        this.consumer = consumer;
        this.channelEndTimes = channelEndTimes;
        this.uniqueThreadsByExitTime = uniqueThreadsByExitTime;
        this.channelData = (TIntObjectMap[])ArrayUtils.create(TIntObjectMap[]::new, (int)channelCount, () -> new TIntObjectHashMap(10, 0.5f, 0));
        this.channelEnded = new boolean[channelCount];
        this.wroteTerminalZero = new boolean[channelCount];
    }

    @Override
    public void commit(long timestamp) throws IOException {
        int channelNumber = 0;
        while (channelNumber < this.channelData.length) {
            if (!this.channelEnded[channelNumber]) {
                TIntObjectMap<PerThreadState> map = this.channelData[channelNumber];
                TIntObjectIterator it = map.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int key = it.key();
                    PerThreadState state = (PerThreadState)it.value();
                    Integer utid = IUniqueIds.mapIntToNullableUtid((int)key);
                    int chanNum = channelNumber;
                    state.forEachThenReset((avg, val) -> this.consumer.consumeCounterValue(chanNum, utid, val, avg));
                }
                if (timestamp > this.channelEndTimes[channelNumber]) {
                    map.clear();
                    this.channelEnded[channelNumber] = true;
                    this.channelData[channelNumber] = (TIntObjectMap)NullChecking.neverNull((Object)TCollections.unmodifiableMap(map));
                }
            } else if (!this.wroteTerminalZero[channelNumber]) {
                this.consumer.consumeCounterValue(channelNumber, null, 0L, true);
                this.wroteTerminalZero[channelNumber] = true;
            }
            ++channelNumber;
        }
        this.consumer.commit(timestamp);
        TIntHashSet utidsToRemove = new TIntHashSet(0);
        int removeUpTo = this.lastExitThreadIndex;
        while (removeUpTo < this.uniqueThreadsByExitTime.length) {
            UniqueThread thread = this.uniqueThreadsByExitTime[removeUpTo];
            if (thread.getNonUid().getEndTime() > timestamp) break;
            utidsToRemove.add(thread.uid);
            ++removeUpTo;
        }
        if (removeUpTo > this.lastExitThreadIndex) {
            int channelNumber2 = 0;
            while (channelNumber2 < this.channelData.length) {
                if (!this.channelEnded[channelNumber2]) {
                    TIntObjectMap<PerThreadState> lastMap = this.channelData[channelNumber2];
                    lastMap.keySet().removeAll((TIntCollection)utidsToRemove);
                }
                ++channelNumber2;
            }
            this.lastExitThreadIndex = removeUpTo;
        }
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        if (this.channelEnded[channelNumber]) {
            assert (false);
            return;
        }
        TIntObjectMap<PerThreadState> channelData = this.channelData[channelNumber];
        int key = IUniqueIds.mapNullableUtidToInt((Integer)utid);
        PerThreadState state = (PerThreadState)channelData.get(key);
        if (state == null) {
            state = new PerThreadState();
            channelData.put(key, (Object)state);
        }
        state.add(value);
    }

    private static interface IValueConsumer<E extends Throwable> {
        public void consume(boolean var1, long var2) throws E;
    }

    private static final class PerThreadState {
        private long lastValue = 0L;
        private final @NonNull TLongList values = new TLongArrayList(1);

        public void add(long value) {
            this.values.add(value);
            this.lastValue = value;
        }

        public <E extends Throwable> void forEachThenReset(@NonNull IValueConsumer<E> consumer) throws E {
            if (!this.values.isEmpty()) {
                TLongIterator it = this.values.iterator();
                while (it.hasNext()) {
                    consumer.consume(true, it.next());
                }
                this.values.clear();
            } else {
                consumer.consume(false, this.lastValue);
            }
        }
    }
}

