/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.binning;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.processing.ClosableCachingStreamReaderAdapter;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisHardwareCounterSupplier;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.ArrayUtils;
import com.arm.utils.ListUtils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisDeltaBinningThreadCounterReader
implements IAnalysisBinningThreadCounterReader {
    private final @NonNull Processor processor;
    private final @NonNull ClosableCachingStreamReaderAdapter<IAnalysisHardwareCounterReader.Value, IAnalysisHardwareCounterSupplier> reader;

    public AnalysisDeltaBinningThreadCounterReader(@NonNull IAnalysisHardwareCounterSupplier reader) {
        this.reader = new ClosableCachingStreamReaderAdapter(reader);
        this.processor = new Processor(reader.getChannelCount());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int getChannelCount() {
        return ((IAnalysisHardwareCounterSupplier)this.reader.stream).getChannelCount();
    }

    @Override
    public void read(long upToTimestamp, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
        IAnalysisHardwareCounterReader.Value value = (IAnalysisHardwareCounterReader.Value)this.reader.head();
        while (value != null && value.timestamp < upToTimestamp) {
            this.processor.insert(consumer, upToTimestamp, value.timestamp, value.channelIndex, value.utid, value.duration, value.value);
            value = (IAnalysisHardwareCounterReader.Value)this.reader.next();
        }
        this.processor.commit(consumer, upToTimestamp);
    }

    protected static final class PerChannelState {
        private final @NonNull TIntLongMap map = new TIntLongHashMap(1, 0.5f, -1, 0L);
        private int pendingCount = 0;
        private final @NonNull TLongList pendingOriginalDurations = new TLongArrayList(1, 0L);
        private final @NonNull TLongList pendingOriginalValues = new TLongArrayList(1, 0L);
        private final @NonNull TLongList pendingRemainingDurations = new TLongArrayList(1, 0L);
        private final @NonNull TLongList pendingRemainingValues = new TLongArrayList(1, 0L);
        private final @NonNull TLongList pendingStartTimestamps = new TLongArrayList(1, 0L);
        private final @NonNull List<@Nullable Integer> pendingUtids = new ArrayList<Integer>();

        protected PerChannelState() {
        }

        private static void inc(@NonNull TIntLongMap map, @Nullable Integer utid, long value) {
            int key = IUniqueIds.mapNullableUtidToInt((Integer)utid);
            map.adjustOrPutValue(key, value, value);
        }

        private static void write(int channelNo, @NonNull TIntLongMap map, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
            TIntLongIterator it = map.iterator();
            while (it.hasNext()) {
                it.advance();
                int key = it.key();
                long value = it.value();
                @Nullable Integer utid = IUniqueIds.mapIntToNullableUtid((int)key);
                consumer.consumeCounterValue(channelNo, utid, value, true);
            }
        }

        public void accumulate(long upToTimestamp, long timestamp, long duration, @Nullable Integer utid, long value) {
            assert (timestamp < upToTimestamp);
            int insertSlot = this.pendingCount;
            int discardableCount = 0;
            int i = 0;
            while (i < this.pendingCount) {
                long pendingValue = this.pendingRemainingValues.get(i);
                if (pendingValue <= 0L || this.consume(upToTimestamp, i, this.pendingStartTimestamps.get(i), this.pendingRemainingDurations.get(i), this.pendingOriginalDurations.get(i), this.pendingUtids.get(i), pendingValue, this.pendingOriginalValues.get(i))) {
                    if (insertSlot == this.pendingCount) {
                        insertSlot = i;
                    }
                    ListUtils.set((TLongList)this.pendingRemainingValues, (int)i, (long)0L);
                    ListUtils.set((TLongList)this.pendingRemainingDurations, (int)i, (long)0L);
                    ++discardableCount;
                } else {
                    discardableCount = 0;
                }
                ++i;
            }
            assert (insertSlot <= this.pendingCount - discardableCount);
            this.pendingCount -= discardableCount;
            insertSlot = Math.min(insertSlot, this.pendingCount);
            if (value > 0L && !this.consume(upToTimestamp, insertSlot, timestamp, duration, duration, utid, value, value)) {
                ListUtils.set((TLongList)this.pendingOriginalValues, (int)insertSlot, (long)value);
                ListUtils.set((TLongList)this.pendingOriginalDurations, (int)insertSlot, (long)duration);
                ListUtils.set(this.pendingUtids, (int)insertSlot, (Object)utid);
                if (insertSlot == this.pendingCount) {
                    ++this.pendingCount;
                }
            }
        }

        public void write(int channelNo, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
            PerChannelState.write(channelNo, this.map, consumer);
            this.map.clear();
        }

        private boolean consume(long upToTimestamp, int pendingIndex, long startTimestamp, long remainingDuration, long originalDuration, @Nullable Integer utid, long remainingValue, long originalValue) {
            assert (remainingDuration >= 0L);
            if (startTimestamp >= upToTimestamp) {
                return false;
            }
            long endTimestamp = startTimestamp + remainingDuration;
            if (endTimestamp <= 0L) {
                return true;
            }
            if (endTimestamp <= upToTimestamp) {
                PerChannelState.inc(this.map, utid, remainingValue);
                return true;
            }
            long durationSoFar = originalDuration - remainingDuration;
            long binDuration = upToTimestamp - startTimestamp;
            long durationAfterBin = durationSoFar + binDuration;
            long valueSoFar = originalValue - remainingValue;
            long valueAfterBin = Math.min(originalValue, originalValue * durationAfterBin / originalDuration);
            long binValue = valueAfterBin - valueSoFar;
            assert (binValue < remainingValue);
            assert (binDuration < remainingDuration);
            PerChannelState.inc(this.map, utid, binValue);
            ListUtils.set((TLongList)this.pendingRemainingValues, (int)pendingIndex, (long)(remainingValue - binValue));
            ListUtils.set((TLongList)this.pendingRemainingDurations, (int)pendingIndex, (long)(remainingDuration - binDuration));
            ListUtils.set((TLongList)this.pendingStartTimestamps, (int)pendingIndex, (long)upToTimestamp);
            return false;
        }
    }

    public static final class Processor
    implements IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor {
        private final @NonNull PerChannelState @NonNull [] accumulators;
        private final boolean @NonNull [] modifiedInIteration;

        public Processor(int channelCount) {
            this.accumulators = (PerChannelState[])ArrayUtils.createNonNull(PerChannelState[]::new, (int)channelCount, i -> new PerChannelState());
            this.modifiedInIteration = new boolean[channelCount];
        }

        @Override
        public void commit(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp) throws IOException {
            int i = 0;
            while (i < this.accumulators.length) {
                PerChannelState map = this.accumulators[i];
                if (!this.modifiedInIteration[i]) {
                    map.accumulate(binEndTimestamp, binEndTimestamp - 1L, 0L, null, 0L);
                }
                this.modifiedInIteration[i] = false;
                map.write(i, consumer);
                ++i;
            }
        }

        @Override
        public void insert(@NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer, long binEndTimestamp, long timestamp, int channelNumber, @Nullable Integer utid, long duration, long value) throws IOException {
            if (timestamp < 0L) {
                return;
            }
            PerChannelState map = this.accumulators[channelNumber];
            map.accumulate(binEndTimestamp, timestamp, duration, utid, value);
            this.modifiedInIteration[channelNumber] = true;
        }
    }
}

