/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import com.arm.streamline.analysis.model.threads.ThreadLifeRange;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class TThread
implements Comparable<TThread> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractPerVmId.PerVmNonUniqueTid mId;
    private final @NonNull List<@NonNull ThreadLifeRange> mObserved;
    private final @NonNull ThreadLifeRange mValid;

    public TThread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractPerVmId.PerVmNonUniqueTid id, long time) {
        this(id, new ArrayList<ThreadLifeRange>(), Long.MIN_VALUE, Long.MAX_VALUE);
        this.observe(time);
    }

    private TThread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractPerVmId.PerVmNonUniqueTid id, @NonNull List<@NonNull ThreadLifeRange> observed, long startTime, long endTime) {
        this.mId = id;
        this.mObserved = observed;
        this.mValid = new ThreadLifeRange(startTime, endTime);
    }

    public void check() {
        this.mValid.check();
        for (ThreadLifeRange observed : this.mObserved) {
            observed.check();
        }
        int i = 0;
        while (i < this.mObserved.size() - 1) {
            if (this.mObserved.get(i).getEndTime() + 1000000000L >= this.mObserved.get(i + 1).getStartTime()) {
                throw new RuntimeException();
            }
            ++i;
        }
        if (!(this.mObserved.isEmpty() || this.mValid.getStartTime() <= this.mObserved.get(0).getStartTime() && this.mValid.getEndTime() >= this.mObserved.get(this.mObserved.size() - 1).getEndTime())) {
            throw new RuntimeException();
        }
    }

    @Override
    public int compareTo(TThread that) {
        long thatStartTime;
        long thisStartTime = this.getObservedStartTime();
        if (thisStartTime < (thatStartTime = that.getObservedStartTime())) {
            return -1;
        }
        if (thisStartTime > thatStartTime) {
            return 1;
        }
        return this.mId.compareTo((AbstractPerVmId)that.mId);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractPerVmId.PerVmNonUniqueTid getId() {
        return this.mId;
    }

    public int getLastCookie() {
        return this.mObserved.get(this.mObserved.size() - 1).getCookie();
    }

    public int getLastCookieScan() {
        int i = this.mObserved.size() - 1;
        while (i >= 0) {
            int cookie = this.mObserved.get(i).getCookie();
            if (cookie != -1) {
                return cookie;
            }
            --i;
        }
        return -1;
    }

    public long getLastCookieTime() {
        return this.mObserved.get(this.mObserved.size() - 1).getCookieTime();
    }

    public @NonNull String getLastName() {
        return this.mObserved.get(this.mObserved.size() - 1).getName();
    }

    public String getLastNameScan() {
        int i = this.mObserved.size() - 1;
        while (i >= 0) {
            String name = this.mObserved.get(i).getName();
            if (!name.isEmpty()) {
                return name;
            }
            --i;
        }
        return "";
    }

    public @NonNull OptionalInt getLastPid() {
        return this.mObserved.get(this.mObserved.size() - 1).getPid();
    }

    public long getObservedEndTime() {
        return this.mObserved.get(this.mObserved.size() - 1).getEndTime();
    }

    public long getObservedStartTime() {
        return this.mObserved.get(0).getStartTime();
    }

    public @NonNull ThreadLifeRange getValid() {
        return this.mValid;
    }

    public boolean isShow() {
        return this.mObserved.get(this.mObserved.size() - 1).isShow();
    }

    public void mergeObserved() {
        while (this.mObserved.size() > 1) {
            int size = this.mObserved.size();
            this.mObserved.get(size - 2).merge(this.mObserved.get(size - 1));
            this.mObserved.remove(size - 1);
        }
    }

    public @NonNull ThreadLifeRange observe(long time) {
        int start = 0;
        int end = this.mObserved.size();
        while (start < end) {
            int pos = (start + end) / 2;
            ThreadLifeRange range = this.mObserved.get(pos);
            int resultClose = range.compareToClose(time);
            if (resultClose < 0) {
                end = pos;
                continue;
            }
            if (resultClose > 0) {
                start = pos + 1;
                continue;
            }
            int resultPrecise = range.compareToPrecise(time);
            if (resultPrecise < 0) {
                if (pos - 1 >= 0 && time - 1000000000L < this.mObserved.get(pos - 1).getEndTime()) {
                    this.mObserved.get(pos - 1).merge(range);
                    this.mObserved.remove(pos);
                } else {
                    range.setStartTime(time);
                }
            } else if (resultPrecise > 0) {
                if (pos + 1 < this.mObserved.size() && time + 1000000000L >= this.mObserved.get(pos + 1).getStartTime()) {
                    range.merge(this.mObserved.get(pos + 1));
                    this.mObserved.remove(pos + 1);
                } else {
                    range.setEndTime(time);
                }
            }
            return range;
        }
        ThreadLifeRange range = new ThreadLifeRange(time, time);
        this.mObserved.add(start, range);
        return range;
    }

    public @Nullable TThread split(long time) {
        long oldEndTime = this.mValid.getEndTime();
        this.mValid.setEndTime(time + 1000000000L);
        int splitPos = 0;
        while (splitPos < this.mObserved.size() && time + 1000000000L > this.mObserved.get(splitPos).getStartTime()) {
            ++splitPos;
        }
        if (splitPos == this.mObserved.size()) {
            return null;
        }
        List<@NonNull ThreadLifeRange> subList = this.mObserved.subList(splitPos, this.mObserved.size());
        ArrayList<@NonNull ThreadLifeRange> newObserved = new ArrayList<ThreadLifeRange>(subList);
        subList.clear();
        return new TThread(this.mId, newObserved, time + 1000000000L + 1L, oldEndTime);
    }

    public String toString() {
        return String.valueOf(this.mId) + "|" + this.mValid.toString() + "|" + this.mObserved.toString();
    }
}

