/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.IMonotonicRawToVmTimestamp;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import org.eclipse.jdt.annotation.Nullable;

public final class VirtualMachineProperties
implements IVirtualMachineProperties,
IMonotonicRawToVmTimestamp {
    private final boolean applicationTracingMode;
    private final @Nullable String name;
    private final long startTime;
    private final long stopTime;
    private final long vmTimestampBase;

    public VirtualMachineProperties(@Nullable String name, long startTime, long stopTime, long vmTimestampBase, boolean applicationTracingMode) {
        assert (startTime <= stopTime);
        this.name = name;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.vmTimestampBase = vmTimestampBase;
        this.applicationTracingMode = applicationTracingMode;
    }

    public long getDuration() {
        return this.isAnyTimesSeen() ? this.stopTime - this.startTime : 0L;
    }

    @Override
    public long getMonotonicRawBase() {
        return this.startTime;
    }

    public long getVmEndTimestamp() {
        return this.vmTimestampBase + this.getDuration();
    }

    public @Nullable String getVmName() {
        return this.name;
    }

    public long getVmStartTimestamp() {
        return this.vmTimestampBase;
    }

    public boolean isAnyTimesSeen() {
        return this.startTime != Long.MAX_VALUE;
    }

    public boolean isApplicationTracingMode() {
        return this.applicationTracingMode;
    }

    public String toString() {
        return String.format("VM:'%s':{%d,%d}+%d", this.name, this.startTime, this.stopTime, this.vmTimestampBase);
    }

    @Override
    public long toVmTimestamp(long globalTimestamp) {
        return globalTimestamp + this.startTime - this.getVmStartTimestamp();
    }
}

