/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterMap {
    private final @NonNull TIntObjectMap<CounterRecord> counters = new TIntObjectHashMap();
    private final @NonNull DeviceTypeCalculator deviceTypeCalculator;
    private final @NonNull TIntObjectMap<DeviceType> deviceTypes = new TIntObjectHashMap();

    public CounterMap(@NonNull DeviceTypeCalculator deviceTypeCalculator) {
        this.deviceTypeCalculator = deviceTypeCalculator;
    }

    public boolean add(@NonNull CounterRecord counter) {
        if (!counter.ignore() && !this.counters.containsKey(counter.getKey())) {
            DeviceType deviceType = this.deviceTypeCalculator.addCounter(counter);
            if (deviceType.isCPU() && !counter.isPerCPU()) {
                deviceType = DeviceType.SYSTEM_WIDE;
            }
            counter.setDeviceType(deviceType);
            this.deviceTypes.put(counter.getKey(), (Object)deviceType);
            if (!counter.isDerived()) {
                this.counters.put(counter.getKey(), (Object)counter);
                return true;
            }
        }
        return false;
    }

    public @NonNull DeviceType getDeviceType(@NonNull CounterRecord record) {
        @Nullable DeviceType result = this.getDeviceType(record.getKey());
        if (result != null) {
            return result;
        }
        return (DeviceType)NullChecking.neverNullOr((Object)record.getDeviceType(), (Object)(record.isPerCPU() ? DeviceType.CPU : DeviceType.SYSTEM_WIDE));
    }

    public @Nullable DeviceType getDeviceType(int key) {
        return (DeviceType)this.deviceTypes.get(key);
    }
}

