/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.CounterMap;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;

public class AllCounters {
    private static final String TAG_COUNTER = "counter";
    private static final String TAG_COUNTERS = "counters";

    public static @NonNull List<@NonNull CounterRecord> read(@NonNull File file) throws IOException {
        ArrayList<@NonNull CounterRecord> result = new ArrayList<CounterRecord>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser in = XMLParser.create((File)file);){
            String tag;
            String marker = in.getMarker();
            while ((tag = in.nextTag(marker)) != null) {
                if (TAG_COUNTERS.equals(tag)) {
                    String countersMarker = in.getMarker();
                    while ((tag = in.nextTag(countersMarker)) != null) {
                        if (TAG_COUNTER.equals(tag)) {
                            try {
                                CounterRecord counter = new CounterRecord(in);
                                result.add(counter);
                            }
                            catch (BadXmlException e) {
                                StdLog.warning((Plugin)CommonPlugin.getInstance(), (String)"Invalid XML in counter record", (Throwable)e);
                            }
                            continue;
                        }
                        in.skip();
                    }
                    continue;
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public static @NonNull CounterMap read(@NonNull File file, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException {
        @NonNull List<@NonNull CounterRecord> list = AllCounters.read(file);
        @NonNull CounterMap result = new CounterMap(deviceTypeCalculator);
        list.forEach(cr -> {
            boolean bl = result.add((CounterRecord)cr);
        });
        return result;
    }

    public static void write(@NonNull File file, @NonNull Collection<@NonNull CounterRecord> counters) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_COUNTERS);
            for (CounterRecord counterRecord : counters) {
                xml.startTag(TAG_COUNTER);
                counterRecord.write(xml);
                xml.endTag();
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

