/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.types;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.types.IndexAddress;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import org.eclipse.jdt.annotation.NonNull;

public class L1IndexEntry
implements Comparable<L1IndexEntry> {
    public final @NonNull IndexAddress dataOffset;
    public final @NonNull IndexTimestampSeqno index;

    public static L1IndexEntry add(L1IndexEntry a, L1IndexEntry b) {
        return new L1IndexEntry(IndexTimestampSeqno.add(a.index, b.index), IndexAddress.add(a.dataOffset, b.dataOffset));
    }

    public static L1IndexEntry subtract(L1IndexEntry a, L1IndexEntry b) {
        return new L1IndexEntry(IndexTimestampSeqno.subtract(a.index, b.index), IndexAddress.subtract(a.dataOffset, b.dataOffset));
    }

    public static @NonNull L1IndexEntry unpackOne(@NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        IndexTimestampSeqno index = IndexTimestampSeqno.unpackOne(unpacker);
        IndexAddress dataOffset = IndexAddress.unpackOne(unpacker);
        return new L1IndexEntry(index, dataOffset);
    }

    private L1IndexEntry(@NonNull IndexTimestampSeqno index, @NonNull IndexAddress dataOffset) {
        this.index = index;
        this.dataOffset = dataOffset;
    }

    @Override
    public int compareTo(L1IndexEntry o) {
        if (this.index.isLessThan(o.index)) {
            return -1;
        }
        if (this.index.isGreaterThan(o.index)) {
            return 1;
        }
        if (this.dataOffset.offset < o.dataOffset.offset || this.dataOffset.offset > o.dataOffset.offset) {
            return -1;
        }
        return 0;
    }

    public boolean isGreaterThan(L1IndexEntry o) {
        return this.compareTo(o) > 0;
    }

    public boolean isLessThan(L1IndexEntry o) {
        return this.compareTo(o) < 0;
    }

    public boolean isLessThanEqualTo(L1IndexEntry o) {
        return !this.isGreaterThan(o);
    }

    public String toString() {
        return "L1IndexEntry{index=" + String.valueOf(this.index) + ", dataOffset=" + String.valueOf(this.dataOffset) + "}";
    }
}

