/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.types;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.types.IndexAddress;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import org.eclipse.jdt.annotation.NonNull;

public class L0IndexEntry
implements Comparable<L0IndexEntry> {
    public final @NonNull IndexTimestampSeqno earliestIndex;
    public final @NonNull IndexTimestampSeqno latestIndex;
    public final @NonNull IndexAddress l1Offset;

    public static @NonNull L0IndexEntry unpackOne(@NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        IndexTimestampSeqno earliestIndex = IndexTimestampSeqno.unpackOne(unpacker);
        IndexTimestampSeqno latestIndex = IndexTimestampSeqno.unpackOne(unpacker);
        IndexAddress l1Offset = IndexAddress.unpackOne(unpacker);
        return new L0IndexEntry(earliestIndex, latestIndex, l1Offset);
    }

    public L0IndexEntry(@NonNull IndexTimestampSeqno earliestIndex, @NonNull IndexTimestampSeqno latestIndex, @NonNull IndexAddress l1Offset) {
        this.earliestIndex = earliestIndex;
        this.latestIndex = latestIndex;
        this.l1Offset = l1Offset;
    }

    @Override
    public int compareTo(L0IndexEntry o) {
        if (this.earliestIndex.isLessThan(o.earliestIndex)) {
            return -1;
        }
        if (this.earliestIndex.isGreaterThan(o.earliestIndex)) {
            return 1;
        }
        if (this.latestIndex.isLessThan(o.latestIndex)) {
            return -1;
        }
        if (this.latestIndex.isGreaterThan(o.latestIndex)) {
            return 1;
        }
        if (this.l1Offset.offset < o.l1Offset.offset) {
            return -1;
        }
        if (this.l1Offset.offset > o.l1Offset.offset) {
            return 1;
        }
        return 0;
    }

    public @NonNull String toString() {
        return "L0IndexEntry{earliestIndex=" + String.valueOf(this.earliestIndex) + ", latestIndex=" + String.valueOf(this.latestIndex) + ", l1Offset=" + String.valueOf(this.l1Offset) + "}";
    }
}

