/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CamStreamParser
implements IStreamParser<IStreamValue> {
    private static final int CAM_VIEW_DEFINITION_PAYLOAD = 0;
    private static final int CAM_TRACK_DEFINITION_PAYLOAD = 1;
    private static final int CAM_JOB_PAYLOAD = 2;
    private static final int CAM_JOB_START_PAYLOAD = 3;
    private static final int CAM_JOB_STOP_PAYLOAD = 4;
    private static final int CAM_JOB_DEPENDENCIES_PAYLOAD = 5;

    @Override
    public @NonNull IStreamValue parseDataPayload(@NonNull IndexTimestampSeqno timeSeqno, @NonNull PackedValueUnpacker reader) {
        int type = reader.unpackOneInt();
        switch (type) {
            case 0: {
                return CamStreamParser.viewDefinition(timeSeqno, reader.unpackOneInt(), DbConstants.toUtid(reader.unpackOneLong()), reader.unpackOneUTF8String());
            }
            case 1: {
                return CamStreamParser.trackDefinition(timeSeqno, reader.unpackOneInt(), reader.unpackOneInt(), reader.unpackOneUTF8String());
            }
            case 2: {
                return CamStreamParser.camJob(timeSeqno, reader.unpackOneInt(), reader.unpackOneInt(), reader.unpackOneLong(), reader.unpackOneInt(), reader.unpackOneInt(), CamStreamParser.readCamJobDependencies(reader), reader.unpackOneUTF8String(), reader.unpackOneUTF8String());
            }
            case 3: {
                return CamStreamParser.camJobStart(timeSeqno, reader.unpackOneInt(), reader.unpackOneInt(), reader.unpackOneInt(), reader.unpackOneUTF8String(), reader.unpackOneUTF8String());
            }
            case 4: {
                return CamStreamParser.camJobStop(timeSeqno, reader.unpackOneInt());
            }
            case 5: {
                return CamStreamParser.camJobDependencies(timeSeqno, reader.unpackOneInt(), reader.unpackOneInt(), CamStreamParser.readCamJobDependencies(reader));
            }
        }
        throw new IllegalStateException("Unexpected type code when extracting cam event: " + type);
    }

    public static @NonNull IStreamValue camJobDependencies(final @NonNull IndexTimestampSeqno timeSeqno, final int jobUid, final int primaryDependencyJobUid, final int @NonNull [] dependencyJobUids) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camJobDependencies(timeSeqno.timestamp, timeSeqno.sequenceNo, jobUid, primaryDependencyJobUid, dependencyJobUids);
            }
        };
    }

    public static @NonNull IStreamValue camJobStop(final @NonNull IndexTimestampSeqno timeSeqno, final int job) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camJobStop(timeSeqno.timestamp, timeSeqno.sequenceNo, job);
            }
        };
    }

    public static @NonNull IStreamValue camJobStart(final @NonNull IndexTimestampSeqno timeSeqno, final int trackUid, final int jobUid, final int colour, final @NonNull String jobName, final @NonNull String detailText) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camJobStart(timeSeqno.timestamp, timeSeqno.sequenceNo, trackUid, jobUid, colour, jobName, detailText);
            }
        };
    }

    public static @NonNull IStreamValue camJob(final @NonNull IndexTimestampSeqno timeSeqno, final int trackUid, final int jobUid, final long duration, final int colour, final int primaryDependencyJobUid, final int @NonNull [] dependencyJobUids, final @NonNull String jobName, final @NonNull String detailText) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camJob(timeSeqno.timestamp, timeSeqno.sequenceNo, trackUid, jobUid, duration, colour, primaryDependencyJobUid, dependencyJobUids, jobName, detailText);
            }
        };
    }

    private static int @NonNull [] readCamJobDependencies(@NonNull PackedValueUnpacker reader) {
        int length = reader.unpackOneInt();
        int[] data = new int[length];
        int i = 0;
        while (i < length) {
            data[i] = reader.unpackOneInt();
            ++i;
        }
        return data;
    }

    public static @NonNull IStreamValue viewDefinition(final @NonNull IndexTimestampSeqno timeSeqno, final int viewUid, final @Nullable Integer utid, final @NonNull String name) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camViewDefinition(timeSeqno.timestamp, timeSeqno.sequenceNo, viewUid, utid, name);
            }
        };
    }

    public static @NonNull IStreamValue trackDefinition(final @NonNull IndexTimestampSeqno timeSeqno, final int parentTrackUid, final int trackUid, final @NonNull String name) {
        return new IStreamValue(){

            @Override
            public void accept(@NonNull IStreamValueVisitor visitor) {
                visitor.camTrackDefinition(timeSeqno.timestamp, timeSeqno.sequenceNo, parentTrackUid, trackUid, name);
            }
        };
    }

    public static interface IStreamValue {
        public void accept(@NonNull IStreamValueVisitor var1);
    }

    public static interface IStreamValueVisitor {
        public void camViewDefinition(long var1, long var3, int var5, @Nullable Integer var6, @NonNull String var7);

        public void camTrackDefinition(long var1, long var3, int var5, int var6, @NonNull String var7);

        public void camJob(long var1, long var3, int var5, int var6, long var7, int var9, int var10, int @NonNull [] var11, @NonNull String var12, @NonNull String var13);

        public void camJobStart(long var1, long var3, int var5, int var6, int var7, @NonNull String var8, @NonNull String var9);

        public void camJobStop(long var1, long var3, int var5);

        public void camJobDependencies(long var1, long var3, int var5, int var6, int @NonNull [] var7);
    }
}

