/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnnotationsStreamParser
implements IStreamParser<StreamValue> {
    @Override
    public StreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker unpacker) throws RuntimeException {
        @NonNull String emptyStr = "";
        int varindex = unpacker.unpackOneInt();
        switch (varindex) {
            case 0: {
                long utid = unpacker.unpackOneLong();
                int color = unpacker.unpackOneInt();
                @NonNull String text = unpacker.unpackOneUTF8String();
                return new StreamValue(index, StreamValueType.BOOKMARK, -1L, -1, color, -1, -1, null, "", text, "", utid);
            }
            case 1: {
                long utid = unpacker.unpackOneLong();
                long domain = unpacker.unpackOneLong();
                int channel = unpacker.unpackOneInt();
                int color = unpacker.unpackOneInt();
                @NonNull String text = unpacker.unpackOneUTF8String();
                return new StreamValue(index, StreamValueType.TEXT, domain, channel, color, -1, -1, null, "", text, "", utid);
            }
            case 2: {
                long utid = unpacker.unpackOneLong();
                long domain = unpacker.unpackOneLong();
                int channel = unpacker.unpackOneInt();
                int group = unpacker.unpackOneInt();
                @NonNull String name = unpacker.unpackOneUTF8String();
                return new StreamValue(index, StreamValueType.NAME_CHANNEL, domain, channel, -1, group, -1, null, name, "", "", utid);
            }
            case 3: {
                long utid = unpacker.unpackOneLong();
                long domain = unpacker.unpackOneLong();
                int group = unpacker.unpackOneInt();
                @NonNull String name = unpacker.unpackOneUTF8String();
                return new StreamValue(index, StreamValueType.NAME_GROUP, domain, -1, -1, group, -1, null, name, "", "", utid);
            }
            case 4: {
                long utid = unpacker.unpackOneLong();
                byte[] image = unpacker.unpackOneImage();
                return new StreamValue(index, StreamValueType.VISUAL, -1L, -1, -1, -1, -1, image, "", "", "", utid);
            }
        }
        throw new RuntimeException("Unknown annotation variant " + varindex);
    }

    public class StreamValue
    implements IPrintable {
        public final IndexTimestampSeqno index;
        public final StreamValueType type;
        public final long domain;
        public final int channel;
        public final int color;
        public final int group;
        public final int id;
        public final byte[] image;
        public final @NonNull String name;
        public final @NonNull String text;
        public final @NonNull String title;
        public final @Nullable Integer utid;

        public StreamValue(IndexTimestampSeqno index, StreamValueType type, long domain, int channel, int color, int group, int id, byte @NonNull [] image, @NonNull String name, @NonNull String text, String title, long utid) {
            this.index = index;
            this.type = type;
            this.domain = domain;
            this.channel = channel;
            this.color = color;
            this.group = group;
            this.id = id;
            this.image = image;
            this.name = name;
            this.text = text;
            this.title = title;
            this.utid = DbConstants.toUtid(utid);
        }

        @Override
        public void printToStream(@NonNull Appendable destination) throws IOException {
            switch (this.type) {
                case BOOKMARK: {
                    destination.append("        BKM: " + this.index.timestamp + " :: " + this.index.sequenceNo + " :: " + String.valueOf(this.utid) + " :: 0x" + Integer.toHexString(this.color) + " :: " + this.text + "\n");
                    break;
                }
                case NAME_CHANNEL: {
                    destination.append("        TNC: " + this.index.timestamp + " :: " + this.index.sequenceNo + " :: " + String.valueOf(this.utid) + " :: " + this.domain + " :: " + this.channel + " :: " + this.group + " :: " + this.name + "\n");
                    break;
                }
                case NAME_GROUP: {
                    destination.append("        TNG: " + this.index.timestamp + " :: " + this.index.sequenceNo + " :: " + String.valueOf(this.utid) + " :: " + this.domain + " :: " + this.group + " :: " + this.name + "\n");
                    break;
                }
                case TEXT: {
                    destination.append("        TXT: " + this.index.timestamp + " :: " + this.index.sequenceNo + " :: " + String.valueOf(this.utid) + " :: " + this.domain + " :: " + this.channel + " :: 0x" + Integer.toHexString(this.color) + " :: " + this.text + "\n");
                    break;
                }
                case VISUAL: {
                    destination.append("        VIS: " + this.index.timestamp + " :: " + this.index.sequenceNo + " :: " + String.valueOf(this.utid) + " :: " + this.image.length + "\n");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown annotation variant " + String.valueOf((Object)this.type));
                }
            }
        }
    }

    public static enum StreamValueType {
        BOOKMARK,
        TEXT,
        NAME_CHANNEL,
        NAME_GROUP,
        VISUAL;

    }
}

