/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.L1IndexEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class StreamValueIterator<T> {
    private final @NonNull IFileDataView dataFile;
    private final @NonNull L1IndexIterator l1IndexIterator;
    private final @NonNull IStreamParser<T> parser;

    public StreamValueIterator(@NonNull IFileDataView data, @NonNull L1IndexIterator l1IndexIterator, @NonNull IStreamParser<T> parser) {
        this.dataFile = data;
        this.l1IndexIterator = l1IndexIterator;
        this.parser = parser;
    }

    public boolean hasNext() {
        return this.l1IndexIterator.hasNext();
    }

    public @NonNull T next() throws IOException {
        L1IndexEntry l1Entry = this.l1IndexIterator.next();
        @NonNull ByteBuffer chunk = this.dataFile.getChunk(l1Entry.dataOffset.offset, l1Entry.dataOffset.size);
        PackedValueUnpacker unpacker = new PackedValueUnpacker(chunk);
        return this.parser.parseDataPayload(l1Entry.index, unpacker);
    }
}

