/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.index;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.index.ChunkListReader;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.types.IndexAddress;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.dbnative.types.L1IndexEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class L1IndexChunkReader
implements Comparable<L1IndexChunkReader> {
    private ByteBuffer currentChunk;
    private @Nullable L1IndexEntry currentIndexEntry;
    private final @NonNull ChunkListReader l1IndexChunkListReader;

    public static @NonNull List<@NonNull L1IndexChunkReader> createFromL0Index(@NonNull IFileDataView data, @NonNull List<@NonNull L0IndexEntry> l0IndexList) throws IOException {
        @NonNull List<@NonNull List<@NonNull IndexAddress>> chains = L1IndexChunkReader.createNonOverlappingChains(l0IndexList);
        @NonNull ArrayList<@NonNull L1IndexChunkReader> result = new ArrayList<L1IndexChunkReader>(chains.size());
        for (List<IndexAddress> entry : chains) {
            result.add(new L1IndexChunkReader(data, entry));
        }
        return result;
    }

    private static boolean appendChain(@NonNull List<@NonNull L0IndexEntry> lastEntry, @NonNull List<@NonNull List<@NonNull IndexAddress>> chains, @NonNull L0IndexEntry entry) {
        assert (lastEntry.size() == chains.size());
        int n = 0;
        while (n < lastEntry.size()) {
            if (lastEntry.get((int)n).latestIndex.isLessThanEqualTo(entry.earliestIndex)) {
                lastEntry.set(n, entry);
                chains.get(n).add(entry.l1Offset);
                return true;
            }
            ++n;
        }
        return false;
    }

    static @NonNull List<@NonNull List<@NonNull IndexAddress>> createNonOverlappingChains(@NonNull List<@NonNull L0IndexEntry> l0IndexList) {
        @NonNull ArrayList<@NonNull L0IndexEntry> lastEntry = new ArrayList<L0IndexEntry>();
        @NonNull ArrayList<@NonNull List<@NonNull IndexAddress>> chains = new ArrayList<List<IndexAddress>>();
        for (L0IndexEntry l0Index : l0IndexList) {
            assert (l0Index.l1Offset.size != 0L);
            if (L1IndexChunkReader.appendChain(lastEntry, chains, l0Index)) continue;
            ArrayList<IndexAddress> chain = new ArrayList<IndexAddress>();
            lastEntry.add(l0Index);
            chain.add(l0Index.l1Offset);
            chains.add(chain);
        }
        return chains;
    }

    private L1IndexChunkReader(@NonNull IFileDataView data, @NonNull List<@NonNull IndexAddress> l0IndexList) throws IOException {
        this.l1IndexChunkListReader = new ChunkListReader(data, l0IndexList);
        this.currentChunk = this.l1IndexChunkListReader.currentChunk();
        this.currentIndexEntry = this.loadNext();
    }

    @Override
    public int compareTo(L1IndexChunkReader o) {
        if (o == null || !o.getClass().equals(o.getClass())) {
            return 1;
        }
        if (this.empty()) {
            if (o.empty()) {
                return 0;
            }
            return -1;
        }
        if (o.empty()) {
            return 1;
        }
        L1IndexEntry currentIndexEntryCopy = this.currentIndexEntry;
        if (currentIndexEntryCopy == null || currentIndexEntryCopy.isLessThan(o.getCurrentIndexEntry())) {
            return -1;
        }
        if (currentIndexEntryCopy.isGreaterThan(o.getCurrentIndexEntry())) {
            return 1;
        }
        return 0;
    }

    public boolean empty() {
        return this.currentIndexEntry == null;
    }

    public @Nullable L1IndexEntry getCurrentIndexEntry() {
        return this.currentIndexEntry;
    }

    public boolean next() throws IOException {
        this.currentIndexEntry = this.loadNext();
        return this.currentIndexEntry != null;
    }

    private @Nullable L1IndexEntry loadNext() throws IOException {
        while (true) {
            if (this.currentChunk.hasRemaining()) {
                @NonNull PackedValueUnpacker unpacker = new PackedValueUnpacker(this.currentChunk);
                L1IndexEntry nextEntry = L1IndexEntry.unpackOne(unpacker);
                L1IndexEntry currentIndexEntryCopy = this.currentIndexEntry;
                if (currentIndexEntryCopy != null) {
                    nextEntry = L1IndexEntry.add(currentIndexEntryCopy, nextEntry);
                    assert (currentIndexEntryCopy.isLessThan(nextEntry));
                    return nextEntry;
                }
                return nextEntry;
            }
            this.currentIndexEntry = null;
            if (!this.l1IndexChunkListReader.nextChunk()) {
                return null;
            }
            this.currentChunk = this.l1IndexChunkListReader.currentChunk();
        }
    }
}

