/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.counters.IAnalysisSpeMultiCounterReader;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeOperationTypePredicate;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseHardwareCounterReaderForInstructionCounterFactory;
import com.arm.streamline.analysis.database.stream.icounter.spe.Messages;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.database.v3.DatabaseSpeReader;
import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.SpeStreamParser;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.IntPair;
import com.arm.utils.collections.LongIntPair;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseSpeCounterReader
extends AbstractDatabaseVmStreamReader<Value, Value>
implements IAnalysisSpeMultiCounterReader {
    private final @NonNull CounterRecord @NonNull [] counters;

    public DatabaseSpeCounterReader(@NonNull CounterRecord @NonNull [] counters, @NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
        this.counters = counters;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public @NonNull CounterRecord @NonNull [] getCounters() {
        return this.counters;
    }

    @Override
    public @Nullable Value read() throws IOException {
        return (Value)this.doRead();
    }

    @Override
    protected @NonNull Value mapStreamValue(@NonNull Value value) {
        return value;
    }

    public static final class DescriptorTransformer {
        private final @NonNull CounterRecord @NonNull [] counterRecords;
        private final @NonNull TLongObjectMap<List<@NonNull SpeEventValueMapper>> vmToValueMappers;

        private static @NonNull Value applyMappers(@NonNull List<@NonNull SpeEventValueMapper> mappers, @NonNull SpeStreamParser.StreamValue dbValue) throws IOException {
            int[] counterIndexes = new int[mappers.size()];
            int[] channelNumbers = new int[mappers.size()];
            long[] durations = new long[mappers.size()];
            long[] values = new long[mappers.size()];
            int insertPos = 0;
            for (SpeEventValueMapper mapper : mappers) {
                boolean inserted = mapper.apply(dbValue, insertPos, counterIndexes, channelNumbers, durations, values);
                if (!inserted) continue;
                ++insertPos;
            }
            return new Value(dbValue.index.timestamp, dbValue.index.sequenceNo, dbValue.utid, insertPos, counterIndexes, channelNumbers, durations, values);
        }

        private static byte @NonNull [] toIndexArray(@NonNull SpeCounterProperties totalLatencyCounter, @NonNull Set<@NonNull SpeCounterProperties> latencyCounters) {
            TByteArrayList list = new TByteArrayList(latencyCounters.size());
            latencyCounters.stream().filter(s -> s != totalLatencyCounter).mapToInt(SpeCounterProperties::getIndex).forEach(i -> {
                boolean bl = list.add(DescriptorTransformer.safeToByte(i));
            });
            return list.toArray();
        }

        private static byte safeToByte(int index) {
            assert (index >= 0 && index < 256);
            return (byte)index;
        }

        private static long counterToLong(short value) {
            return Short.toUnsignedLong(value);
        }

        private static int dataSourceToInt(short dataSource) {
            return Short.toUnsignedInt(dataSource);
        }

        public DescriptorTransformer(@NonNull TLongObjectHashMap<TIntObjectHashMap<SpeTargetDescription>> speDescriptorMap, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
            HashMap<SpeTargetDescription, TLongIntMap> speDescriptionToVmToMaxDeviceNo = new HashMap<SpeTargetDescription, TLongIntMap>();
            TLongObjectIterator vmIt = speDescriptorMap.iterator();
            while (vmIt.hasNext()) {
                vmIt.advance();
                long vm = vmIt.key();
                TIntObjectHashMap byDevice = (TIntObjectHashMap)vmIt.value();
                if (byDevice == null || byDevice.isEmpty()) continue;
                TIntObjectIterator devIt = byDevice.iterator();
                while (devIt.hasNext()) {
                    TLongIntMap vmToDev;
                    int prevMaxDeviceNo;
                    devIt.advance();
                    int deviceNo = devIt.key();
                    SpeTargetDescription description = (SpeTargetDescription)devIt.value();
                    if (deviceNo < 0 || description == null || (prevMaxDeviceNo = (vmToDev = speDescriptionToVmToMaxDeviceNo.computeIfAbsent(description, k -> new TLongIntHashMap(10, 0.5f, 0L, -1))).get(vm)) >= deviceNo) continue;
                    vmToDev.put(vm, deviceNo);
                }
            }
            boolean hasMultipleDescriptors = speDescriptionToVmToMaxDeviceNo.size() != 1;
            Builder builder = new Builder();
            for (Map.Entry entry : speDescriptionToVmToMaxDeviceNo.entrySet()) {
                SpeTargetDescription description = (SpeTargetDescription)entry.getKey();
                TLongIntMap vmToMaxDeviceNo = (TLongIntMap)entry.getValue();
                builder.processDescription(processingElementsReferenceSet, description, vmToMaxDeviceNo, hasMultipleDescriptors);
            }
            this.vmToValueMappers = builder.vmToValueMappers;
            this.counterRecords = builder.counterRecords.toArray(new CounterRecord[builder.counterRecords.size()]);
        }

        public @Nullable IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull Value, IOException> createTransformer(long vm) {
            List mappers = (List)this.vmToValueMappers.get(vm);
            if (mappers == null) {
                return null;
            }
            return dbValue -> DescriptorTransformer.applyMappers(mappers, dbValue);
        }

        public @NonNull CounterRecord @NonNull [] getCounterRecords() {
            return this.counterRecords;
        }

        private static final class Builder {
            private final @NonNull List<@NonNull CounterRecord> counterRecords = new ArrayList<CounterRecord>();
            private final @NonNull TLongObjectMap<List<@NonNull SpeEventValueMapper>> vmToValueMappers = new TLongObjectHashMap(10, 0.5f, 0L);

            private Builder() {
            }

            private static @NonNull TLongObjectMap<IntPair> calculateChannelIndexBaseAndCounts(@NonNull ProcessingElementReference @NonNull [] processingElements) {
                TLongObjectHashMap result = new TLongObjectHashMap(10, 0.5f, 0L);
                long currentVmUid = 0L;
                int currentDeviceNo = 0;
                int vmBaseIndex = 0;
                int ndx = 0;
                while (ndx < processingElements.length) {
                    ProcessingElementReference processingElement = processingElements[ndx];
                    if (ndx == 0) {
                        if (processingElement.deviceNumber != 0) {
                            throw new AssertionError((Object)"Invalid device number");
                        }
                        currentVmUid = processingElement.vmUID;
                        currentDeviceNo = 0;
                        vmBaseIndex = 0;
                    } else if (processingElement.deviceNumber == 0) {
                        if (processingElement.vmUID <= currentVmUid) {
                            throw new AssertionError((Object)"Invalid sequence");
                        }
                        result.put(currentVmUid, (Object)new IntPair(vmBaseIndex, ndx - vmBaseIndex));
                        currentVmUid = processingElement.vmUID;
                        currentDeviceNo = 0;
                        vmBaseIndex = ndx;
                    } else if (processingElement.vmUID != currentVmUid || processingElement.deviceNumber != ++currentDeviceNo) {
                        throw new AssertionError();
                    }
                    ++ndx;
                }
                result.put(currentVmUid, (Object)new IntPair(vmBaseIndex, processingElements.length - vmBaseIndex));
                return result;
            }

            private static int calculateTotalProcessingElements(@NonNull TLongIntMap vmToMaxDeviceNo) {
                int result = 0;
                TLongIntIterator it = vmToMaxDeviceNo.iterator();
                while (it.hasNext()) {
                    it.advance();
                    result += it.value() + 1;
                }
                return result;
            }

            private static @NonNull String formatTitle(@NonNull String title, boolean hasMultipleDescriptors, @NonNull String targetName) {
                if (!hasMultipleDescriptors) {
                    return title;
                }
                return String.format("%s (%s)", title, targetName);
            }

            private static @NonNull ProcessingElementReference @NonNull [] populateGaps(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull TLongIntMap vmToMaxDeviceNo) {
                int totalProcessingElements = Builder.calculateTotalProcessingElements(vmToMaxDeviceNo);
                Object[] result = new ProcessingElementReference[totalProcessingElements];
                int index = 0;
                TLongIntIterator it = vmToMaxDeviceNo.iterator();
                while (it.hasNext()) {
                    it.advance();
                    long vmUID = it.key();
                    int maxDeviceNo = it.value() + 1;
                    int deviceNo = 0;
                    while (deviceNo < maxDeviceNo) {
                        result[index++] = processingElementsReferenceSet.get(DeviceType.CPU, vmUID, deviceNo);
                        ++deviceNo;
                    }
                }
                Arrays.sort(result);
                return result;
            }

            public void processDescription(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull SpeTargetDescription description, @NonNull TLongIntMap vmToMaxDeviceNo, boolean hasMultipleDescriptors) {
                ProcessingElementReference[] processingElements = Builder.populateGaps(processingElementsReferenceSet, vmToMaxDeviceNo);
                TLongObjectMap<IntPair> deviceToChannelMappingData = Builder.calculateChannelIndexBaseAndCounts(processingElements);
                Set<SpeCounterProperties> latencyCounters = description.getAllSpeCounters().stream().filter(s -> s.getType() == SpeCounterProperties.Type.LATENCY).collect(Collectors.toSet());
                SpeCounterProperties totalLatencyCounter = latencyCounters.stream().filter(s -> s.getIndex() == 0).findFirst().orElse(null);
                this.addLatencyCounters(processingElements, deviceToChannelMappingData, totalLatencyCounter, latencyCounters, hasMultipleDescriptors, description.getName());
                Set<SpeCounterProperties> otherCounters = description.getAllSpeCounters().stream().filter(s -> s.getType() != SpeCounterProperties.Type.LATENCY).collect(Collectors.toSet());
                this.addOtherCounters(processingElements, deviceToChannelMappingData, otherCounters, hasMultipleDescriptors, description.getName());
                this.addDataSourceCounters(processingElements, deviceToChannelMappingData, description.getAllSpeDataSources(), totalLatencyCounter, hasMultipleDescriptors, description.getName());
                this.addEventCounters(processingElements, deviceToChannelMappingData, description.getAllSpePacketEvents(), totalLatencyCounter, hasMultipleDescriptors, description.getName());
            }

            private void addDataSourceCounters(@NonNull ProcessingElementReference @NonNull [] processingElements, @NonNull TLongObjectMap<IntPair> deviceToChannelMappingData, @NonNull Set<@NonNull SpeDataSourceProperties> dataSources, @Nullable SpeCounterProperties totalLatencyCounter, boolean hasMultipleDescriptors, @NonNull String targetName) {
                TIntIntHashMap sourceToCounterIndex = new TIntIntHashMap(dataSources.size(), 1.0f, -1, -1);
                TIntIntHashMap sourceToLatencyCounterIndex = new TIntIntHashMap(dataSources.size(), 1.0f, -1, -1);
                TreeSet<SpeDataSourceProperties> sorted = new TreeSet<SpeDataSourceProperties>(Comparator.comparing(SpeDataSourceProperties::getIndex));
                sorted.addAll(dataSources);
                int order = 0;
                for (SpeDataSourceProperties properties : sorted) {
                    CounterRecord counterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle(Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_TITLE, hasMultipleDescriptors, targetName), properties.getName(), properties.getDescription(), "", CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, null, processingElements, false);
                    counterRecord.setOrder(order);
                    sourceToCounterIndex.put(properties.getIndex(), this.trackCounterRecord(counterRecord));
                    if (totalLatencyCounter != null) {
                        CounterRecord counterRecordLatency = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Data Source (Latency)", hasMultipleDescriptors, targetName), properties.getName(), String.format("Cumulative latency for %s", properties.getName()), totalLatencyCounter.getUnit(), CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, null, processingElements, true);
                        counterRecordLatency.setOrder(order);
                        sourceToLatencyCounterIndex.put(properties.getIndex(), this.trackCounterRecord(counterRecordLatency));
                    }
                    ++order;
                }
                if (!sourceToCounterIndex.isEmpty()) {
                    this.addValueExtractor(deviceToChannelMappingData, new DataSourceValueExtractor((TIntIntMap)sourceToCounterIndex));
                }
                if (totalLatencyCounter != null && !sourceToLatencyCounterIndex.isEmpty()) {
                    this.addValueExtractor(deviceToChannelMappingData, new DataSourceTotalLatencyValueExtractor(DescriptorTransformer.safeToByte(totalLatencyCounter.getIndex()), (TIntIntMap)sourceToLatencyCounterIndex));
                }
            }

            private void addEventCounters(@NonNull ProcessingElementReference @NonNull [] processingElements, @NonNull TLongObjectMap<IntPair> deviceToChannelMappingData, @NonNull Set<@NonNull SpePacketEventProperties> events, @Nullable SpeCounterProperties totalLatencyCounter, boolean hasMultipleDescriptors, @NonNull String targetName) {
                for (SpePacketEventProperties properties : events) {
                    String missLabel;
                    String hitLabel;
                    boolean hitIsClear;
                    boolean hideClear;
                    boolean hideSet = switch (properties.getShowByDefault()) {
                        case SpePacketEventProperties.ShowByDefault.CLEAR -> {
                            hideClear = false;
                            yield true;
                        }
                        case SpePacketEventProperties.ShowByDefault.RATIO -> {
                            hideClear = false;
                            yield false;
                        }
                        case SpePacketEventProperties.ShowByDefault.SET -> {
                            hideClear = true;
                            yield false;
                        }
                        default -> throw new AssertionError(properties.getShowByDefault());
                    };
                    @NonNull OpTypePredicate operationTypePredicate = new OpTypePredicate(properties);
                    int bitIndex = properties.getBitPosition();
                    Integer conditionBit = properties.getConditionBit();
                    boolean accessIsClear = properties.isConditionalAccessOnBitClear();
                    boolean useNeutralColours = switch (properties.getSetMode()) {
                        case SpePacketEventProperties.SetMode.NEGATIVE -> {
                            hitIsClear = true;
                            hitLabel = properties.getClearLabel();
                            missLabel = properties.getSetLabel();
                            yield false;
                        }
                        case SpePacketEventProperties.SetMode.NEUTRAL -> {
                            hitIsClear = false;
                            hitLabel = properties.getSetLabel();
                            missLabel = properties.getClearLabel();
                            yield true;
                        }
                        case SpePacketEventProperties.SetMode.POSITIVE -> {
                            hitIsClear = false;
                            hitLabel = properties.getSetLabel();
                            missLabel = properties.getClearLabel();
                            yield false;
                        }
                        default -> throw new AssertionError(properties.getSetMode());
                    };
                    @NonNull Integer hitColour = useNeutralColours ? DatabaseSpeReader.COLOUR_RBG_SET : DatabaseSpeReader.COLOUR_RBG_HIT;
                    @NonNull Integer missColour = useNeutralColours ? DatabaseSpeReader.COLOUR_RBG_CLEAR : DatabaseSpeReader.COLOUR_RBG_MISS;
                    String chartTitle = Builder.formatTitle(properties.getRatioLabel(), hasMultipleDescriptors, targetName);
                    CounterRecord hitCounterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(chartTitle, hitLabel, (String)NullChecking.neverNullOr((Object)properties.getDescription(), (Object)""), "", CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, hitColour, processingElements, hitIsClear ? hideClear : hideSet);
                    CounterRecord missCounterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(chartTitle, missLabel, (String)NullChecking.neverNullOr((Object)properties.getDescription(), (Object)""), "", CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, missColour, processingElements, hitIsClear ? hideSet : hideClear);
                    this.addValueExtractor(deviceToChannelMappingData, new EventValueExtractor(this.trackCounterRecord(hitCounterRecord), this.trackCounterRecord(missCounterRecord), bitIndex, hitIsClear, conditionBit, accessIsClear, operationTypePredicate));
                    if (totalLatencyCounter == null) continue;
                    String chartTitleLatency = Builder.formatTitle(properties.getRatioLabel() + " (Latency)", hasMultipleDescriptors, targetName);
                    CounterRecord hitCounterRecordLatency = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(chartTitleLatency, hitLabel, String.format("Cumulative latency for %s", hitLabel), totalLatencyCounter.getUnit(), CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, hitColour, processingElements, true);
                    CounterRecord missCounterRecordLatency = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(chartTitleLatency, missLabel, String.format("Cumulative latency for %s", missLabel), totalLatencyCounter.getUnit(), CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, missColour, processingElements, true);
                    this.addValueExtractor(deviceToChannelMappingData, new EventLatencyValueExtractor(DescriptorTransformer.safeToByte(totalLatencyCounter.getIndex()), this.trackCounterRecord(hitCounterRecordLatency), this.trackCounterRecord(missCounterRecordLatency), bitIndex, hitIsClear, conditionBit, accessIsClear, operationTypePredicate));
                }
            }

            private void addLatencyCounters(@NonNull ProcessingElementReference @NonNull [] processingElements, @NonNull TLongObjectMap<IntPair> deviceToChannelMappingData, @Nullable SpeCounterProperties totalLatencyCounter, @NonNull Set<@NonNull SpeCounterProperties> latencyCounters, boolean hasMultipleDescriptors, @NonNull String targetName) {
                for (SpeCounterProperties properties : latencyCounters) {
                    assert (properties.getType() == SpeCounterProperties.Type.LATENCY);
                    CounterRecord counterRecordAbsolute = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Latency", hasMultipleDescriptors, targetName), properties.getName(), properties.getDescription(), properties.getUnit(), CounterClass.ABSOLUTE, GraphRenderingType.LINE, properties == totalLatencyCounter ? SeriesComposition.OVERLAY : SeriesComposition.STACKED, null, processingElements, false);
                    this.addValueExtractor(deviceToChannelMappingData, new CounterValueExtractor(this.trackCounterRecord(counterRecordAbsolute), DescriptorTransformer.safeToByte(properties.getIndex())));
                    CounterRecord counterRecordCumulative = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Latency (Cumulative)", hasMultipleDescriptors, targetName), properties.getName(), properties.getDescription(), properties.getUnit(), CounterClass.INCIDENT, GraphRenderingType.LINE, properties == totalLatencyCounter ? SeriesComposition.OVERLAY : SeriesComposition.STACKED, null, processingElements, true);
                    this.addValueExtractor(deviceToChannelMappingData, new CounterValueExtractor(this.trackCounterRecord(counterRecordCumulative), DescriptorTransformer.safeToByte(properties.getIndex())));
                }
                if (totalLatencyCounter != null && latencyCounters.size() > 1) {
                    assert (totalLatencyCounter.getType() == SpeCounterProperties.Type.LATENCY);
                    byte[] otherLatencyCounters = DescriptorTransformer.toIndexArray(totalLatencyCounter, latencyCounters);
                    CounterRecord counterRecordAbsolute = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Latency", hasMultipleDescriptors, targetName), "All other sources", String.format("All latency counted in %s, but not explicitly counted by any other SPE counter", totalLatencyCounter.getName()), totalLatencyCounter.getUnit(), CounterClass.ABSOLUTE, GraphRenderingType.LINE, SeriesComposition.OVERLAY, null, processingElements, false);
                    this.addValueExtractor(deviceToChannelMappingData, new RemainingLatencyCounterValueExtractor(this.trackCounterRecord(counterRecordAbsolute), DescriptorTransformer.safeToByte(totalLatencyCounter.getIndex()), otherLatencyCounters));
                    CounterRecord counterRecordCumulative = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Latency (Cumulative)", hasMultipleDescriptors, targetName), "All other sources", String.format("All latency counted in %s, but not explicitly counted by any other SPE counter", totalLatencyCounter.getName()), totalLatencyCounter.getUnit(), CounterClass.INCIDENT, GraphRenderingType.LINE, SeriesComposition.OVERLAY, null, processingElements, true);
                    this.addValueExtractor(deviceToChannelMappingData, new RemainingLatencyCounterValueExtractor(this.trackCounterRecord(counterRecordCumulative), DescriptorTransformer.safeToByte(totalLatencyCounter.getIndex()), otherLatencyCounters));
                }
            }

            private void addOtherCounters(@NonNull ProcessingElementReference @NonNull [] processingElements, @NonNull TLongObjectMap<IntPair> deviceToChannelMappingData, @NonNull Set<@NonNull SpeCounterProperties> otherCounters, boolean hasMultipleDescriptors, @NonNull String targetName) {
                for (SpeCounterProperties properties : otherCounters) {
                    assert (properties.getType() == SpeCounterProperties.Type.ABSOLUTE);
                    CounterRecord counterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Builder.formatTitle("Other Counters", hasMultipleDescriptors, targetName), properties.getName(), properties.getDescription(), properties.getUnit(), CounterClass.ABSOLUTE, GraphRenderingType.LINE, SeriesComposition.OVERLAY, null, processingElements, false);
                    this.addValueExtractor(deviceToChannelMappingData, new CounterValueExtractor(this.trackCounterRecord(counterRecord), DescriptorTransformer.safeToByte(properties.getIndex())));
                }
            }

            private void addValueExtractor(@NonNull TLongObjectMap<IntPair> deviceToChannelMappingData, @NonNull IValueExtractor counterValueExtractor) {
                TLongObjectIterator it = deviceToChannelMappingData.iterator();
                while (it.hasNext()) {
                    it.advance();
                    long vmUID = it.key();
                    int channelNoBase = ((IntPair)it.value()).first;
                    int channelCount = ((IntPair)it.value()).second;
                    ArrayList<SpeEventValueMapper> list = (ArrayList<SpeEventValueMapper>)this.vmToValueMappers.get(vmUID);
                    if (list == null) {
                        list = new ArrayList<SpeEventValueMapper>();
                        this.vmToValueMappers.put(vmUID, list);
                    }
                    list.add(new SpeEventValueMapper(counterValueExtractor, channelNoBase, channelCount));
                }
            }

            private int trackCounterRecord(@NonNull CounterRecord counterRecord) {
                int result = this.counterRecords.size();
                assert (!this.counterRecords.contains(counterRecord));
                this.counterRecords.add(counterRecord);
                return result;
            }
        }

        private static final class CounterValueExtractor
        implements IValueExtractor {
            private final int targetIndex;
            private final byte valueIndex;

            public CounterValueExtractor(int targetIndex, byte valueIndex) {
                this.targetIndex = targetIndex;
                this.valueIndex = valueIndex;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) {
                if (!dbValue.counters.containsKey(this.valueIndex)) {
                    return null;
                }
                short value = dbValue.counters.get(this.valueIndex);
                return new LongIntPair(DescriptorTransformer.counterToLong(value), this.targetIndex);
            }
        }

        private static final class DataSourceTotalLatencyValueExtractor
        implements IValueExtractor {
            private final @NonNull TIntIntMap sourceToCounterIndex;
            private final byte totalLatencyCounterIndex;

            public DataSourceTotalLatencyValueExtractor(byte totalLatencyCounterIndex, @NonNull TIntIntMap sourceToCounterIndex) {
                this.totalLatencyCounterIndex = totalLatencyCounterIndex;
                this.sourceToCounterIndex = sourceToCounterIndex;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) {
                if (!dbValue.counters.containsKey(this.totalLatencyCounterIndex)) {
                    return null;
                }
                short totalLatency = dbValue.counters.get(this.totalLatencyCounterIndex);
                Short dataSource = dbValue.dataSources;
                if (dataSource == null) {
                    return null;
                }
                int index = this.sourceToCounterIndex.get(DescriptorTransformer.dataSourceToInt(dataSource));
                if (index < 0) {
                    return null;
                }
                return new LongIntPair(DescriptorTransformer.counterToLong(totalLatency), index);
            }
        }

        private static final class DataSourceValueExtractor
        implements IValueExtractor {
            private final @NonNull TIntIntMap sourceToCounterIndex;

            public DataSourceValueExtractor(@NonNull TIntIntMap sourceToCounterIndex) {
                this.sourceToCounterIndex = sourceToCounterIndex;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) {
                Short dataSource = dbValue.dataSources;
                if (dataSource == null) {
                    return null;
                }
                int index = this.sourceToCounterIndex.get(DescriptorTransformer.dataSourceToInt(dataSource));
                if (index < 0) {
                    return null;
                }
                return new LongIntPair(1L, index);
            }
        }

        private static final class EventLatencyValueExtractor
        extends EventValueExtractor {
            private final byte totalLatencyCounterIndex;

            public EventLatencyValueExtractor(byte totalLatencyCounterIndex, int hitCounterIndex, int missCounterIndex, int bitIndex, boolean hitIsClear, @Nullable Integer conditionBit, boolean accessIsClear, @NonNull ISpeOperationTypePredicate operationTypePredicate) {
                super(hitCounterIndex, missCounterIndex, bitIndex, hitIsClear, conditionBit, accessIsClear, operationTypePredicate);
                this.totalLatencyCounterIndex = totalLatencyCounterIndex;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) throws IOException {
                if (!dbValue.counters.containsKey(this.totalLatencyCounterIndex)) {
                    return null;
                }
                short totalLatency = dbValue.counters.get(this.totalLatencyCounterIndex);
                Boolean matches = this.testMatches(dbValue);
                if (matches == null) {
                    return null;
                }
                return new LongIntPair(DescriptorTransformer.counterToLong(totalLatency), matches != false ? this.hitCounterIndex : this.missCounterIndex);
            }
        }

        private static class EventValueExtractor
        implements IValueExtractor {
            protected final int hitCounterIndex;
            protected final int missCounterIndex;
            private final boolean accessIsClear;
            private final long accessMask;
            private final boolean hitIsClear;
            private final long mask;
            private final @NonNull ISpeOperationTypePredicate operationTypePredicate;

            public EventValueExtractor(int hitCounterIndex, int missCounterIndex, int bitIndex, boolean hitIsClear, @Nullable Integer conditionBit, boolean accessIsClear, @NonNull ISpeOperationTypePredicate operationTypePredicate) {
                if (bitIndex < 0 || bitIndex > 63) {
                    throw new IllegalArgumentException();
                }
                this.mask = 1L << bitIndex;
                if (conditionBit != null) {
                    int accessBitIndex = conditionBit;
                    if (accessBitIndex < 0 || accessBitIndex > 63 || bitIndex < 0 || bitIndex > 63) {
                        throw new IllegalArgumentException();
                    }
                    this.accessMask = 1L << accessBitIndex;
                } else {
                    this.accessMask = 0L;
                }
                this.hitCounterIndex = hitCounterIndex;
                this.missCounterIndex = missCounterIndex;
                this.hitIsClear = hitIsClear;
                this.accessIsClear = accessIsClear;
                this.operationTypePredicate = operationTypePredicate;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) throws IOException {
                Boolean matches = this.testMatches(dbValue);
                if (matches == null) {
                    return null;
                }
                return new LongIntPair(1L, matches != false ? this.hitCounterIndex : this.missCounterIndex);
            }

            protected final @Nullable Boolean testMatches(@NonNull SpeStreamParser.StreamValue dbValue) throws IOException {
                boolean opTypeValid;
                boolean accessHit;
                Long events = dbValue.events;
                if (events == null) {
                    return null;
                }
                boolean accessBitSet = (events & this.accessMask) == this.accessMask;
                boolean bl = accessHit = this.accessMask == 0L || this.accessIsClear ^ accessBitSet;
                if (!accessHit) {
                    return null;
                }
                SpeStreamParser.SpeOpTypeTuple opType = dbValue.opType;
                boolean bl2 = opTypeValid = opType == null ? this.operationTypePredicate.test(null, (byte)0) : this.operationTypePredicate.test(DatabaseSpeReader.mapOpClazz(opType.clazz), opType.subclazz);
                if (!opTypeValid) {
                    return null;
                }
                boolean bitSet = (events & this.mask) == this.mask;
                boolean hit = this.hitIsClear ^ bitSet;
                return hit;
            }
        }

        private static interface IValueExtractor {
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue var1) throws IOException;
        }

        private static final class OpTypePredicate
        implements ISpeOperationTypePredicate {
            private final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractSpeEventProperties.ValidOpType> validOpTypes;

            private OpTypePredicate(@NonNull SpePacketEventProperties properties) {
                this.validOpTypes = properties.getValidOpTypes();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof OpTypePredicate) {
                    OpTypePredicate that = (OpTypePredicate)obj;
                    return this.validOpTypes.equals(that.validOpTypes);
                }
                return false;
            }

            public int hashCode() {
                return this.validOpTypes.hashCode();
            }

            @Override
            public boolean test(@Nullable SpeOperationTypeClass opClass, byte subClass) {
                if (this.validOpTypes.isEmpty()) {
                    return true;
                }
                if (opClass == null) {
                    return false;
                }
                return this.validOpTypes.stream().anyMatch(type -> type.matches(opClass, subClass));
            }
        }

        private static final class RemainingLatencyCounterValueExtractor
        implements IValueExtractor {
            private final byte @NonNull [] otherLatencyIndexes;
            private final int targetIndex;
            private final byte totalLatencyIndex;

            public RemainingLatencyCounterValueExtractor(int targetIndex, byte totalLatencyIndex, byte @NonNull [] otherLatencyIndexes) {
                this.targetIndex = targetIndex;
                this.totalLatencyIndex = totalLatencyIndex;
                this.otherLatencyIndexes = otherLatencyIndexes;
            }

            @Override
            public @Nullable LongIntPair apply(@NonNull SpeStreamParser.StreamValue dbValue) {
                if (!dbValue.counters.containsKey(this.totalLatencyIndex)) {
                    return null;
                }
                short totalLatency = dbValue.counters.get(this.totalLatencyIndex);
                long cumulativeLatency = 0L;
                byte[] byArray = this.otherLatencyIndexes;
                int n = this.otherLatencyIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    byte index = byArray[n2];
                    assert (index != this.totalLatencyIndex);
                    if (dbValue.counters.containsKey(index)) {
                        short latency = dbValue.counters.get(index);
                        cumulativeLatency += DescriptorTransformer.counterToLong(latency);
                    }
                    ++n2;
                }
                return new LongIntPair(Math.max(DescriptorTransformer.counterToLong(totalLatency) - cumulativeLatency, 0L), this.targetIndex);
            }
        }

        private static final class SpeEventValueMapper {
            private final int deviceNoCount;
            private final int deviceNoToChannelIndexBase;
            private final @NonNull IValueExtractor valueExtractor;

            public SpeEventValueMapper(@NonNull IValueExtractor valueExtractor, int deviceNoToChannelIndexBase, int deviceNoCount) {
                this.valueExtractor = valueExtractor;
                this.deviceNoToChannelIndexBase = deviceNoToChannelIndexBase;
                this.deviceNoCount = deviceNoCount;
            }

            public boolean apply(@NonNull SpeStreamParser.StreamValue dbValue, int insertPos, int @NonNull [] counterIndexes, int @NonNull [] channelNumbers, long @NonNull [] durations, long @NonNull [] values) throws IOException {
                int deviceNo = dbValue.deviceNo;
                if (deviceNo < 0 || deviceNo >= this.deviceNoCount) {
                    throw new AssertionError((Object)"Invalid deviceNo");
                }
                int channelIndex = this.deviceNoToChannelIndexBase + deviceNo;
                LongIntPair valueAndCounterIndex = this.valueExtractor.apply(dbValue);
                if (valueAndCounterIndex == null) {
                    return false;
                }
                counterIndexes[insertPos] = valueAndCounterIndex.second;
                channelNumbers[insertPos] = channelIndex;
                durations[insertPos] = 0L;
                values[insertPos] = valueAndCounterIndex.first;
                return true;
            }
        }
    }

    public static final class Value
    implements AbstractDatabaseVmStreamReader.IStreamValue,
    IAnalysisSpeMultiCounterReader.IValue {
        private final int @NonNull [] channelNumbers;
        private final int @NonNull [] counterIndexes;
        private final long @NonNull [] durations;
        private final int numEntries;
        private final long sequenceNo;
        private final long timestamp;
        private final @Nullable Integer utid;
        private final long @NonNull [] values;

        public Value(long timestamp, long sequenceNo, @Nullable Integer utid, int numEntries, int @NonNull [] counterIndexes, int @NonNull [] channelNumbers, long @NonNull [] durations, long @NonNull [] values) {
            this.timestamp = timestamp;
            this.sequenceNo = sequenceNo;
            this.utid = utid;
            this.numEntries = numEntries;
            this.counterIndexes = counterIndexes;
            this.channelNumbers = channelNumbers;
            this.durations = durations;
            this.values = values;
        }

        @Override
        public int getChannelNumber(int counterIndex) {
            return this.channelNumbers[counterIndex];
        }

        @Override
        public int getCounterRecordIndex(int entryIndex) {
            return this.counterIndexes[entryIndex];
        }

        @Override
        public long getDuration(int counterIndex) {
            return this.durations[counterIndex];
        }

        @Override
        public int getNumEntries() {
            return this.numEntries;
        }

        @Override
        public long getSequenceNo() {
            return this.sequenceNo;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public @Nullable Integer getUtid() {
            return this.utid;
        }

        @Override
        public long getValue(int counterIndex) {
            return this.values[counterIndex];
        }
    }

    public static final class VmStream
    implements IThrowingSupplier<Value, IOException> {
        private final @NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull Value, IOException> transformer;
        private final @NonNull StreamValueIterator<SpeStreamParser.StreamValue> valueIterator;

        public VmStream(@NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull Value, IOException> transformer, @NonNull IExecutablePathsMap executablePaths, long vmuid, @NonNull List<@NonNull L0IndexEntry> l0Entries, @NonNull IFileDataView view) throws IOException {
            this.transformer = transformer;
            this.valueIterator = new StreamValueIterator<SpeStreamParser.StreamValue>(view, L1IndexIterator.createFromL0Index(view, l0Entries), new SpeStreamParser(executablePaths));
        }

        public @Nullable Value get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            return (Value)this.transformer.apply((Object)this.valueIterator.next());
        }
    }
}

